/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.ParameterValidator;
import net.fortuna.ical4j.util.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DateProperty
extends Property {
    private Log log = LogFactory.getLog((Class)DateProperty.class);
    private Date date;
    protected TimeZone timezone;

    public DateProperty(String name, ParameterList parameters) {
        super(name, parameters);
    }

    public DateProperty(String name) {
        super(name);
    }

    public DateProperty(String name, TimeZone timezone) {
        super(name);
        this.updateTimeZone(timezone);
    }

    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date date) {
        this.date = date;
        if (date instanceof DateTime) {
            if (this.getParameter("VALUE") != null) {
                this.getParameters().replace(Value.DATE_TIME);
            }
            this.updateTimeZone(((DateTime)date).getTimeZone());
        } else {
            if (date != null) {
                this.getParameters().replace(Value.DATE);
            }
            this.updateTimeZone(null);
        }
    }

    public void setValue(String value) throws ParseException {
        if (Value.DATE.equals(this.getParameter("VALUE"))) {
            this.setValueAsDate(value);
        } else {
            try {
                this.date = new DateTime(value, this.timezone);
            }
            catch (ParseException x) {
                this.setValueAsDate(value);
            }
        }
    }

    private void setValueAsDate(String value) throws ParseException {
        this.updateTimeZone(null);
        this.date = new Date(value);
        if (!Value.DATE.equals(this.getParameter("VALUE"))) {
            this.getParameters().add(Value.DATE);
        }
    }

    public String getValue() {
        return Strings.valueOf(this.getDate());
    }

    public void setTimeZone(TimeZone timezone) {
        this.updateTimeZone(timezone);
    }

    private void updateTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        if (timezone != null) {
            if (this.getDate() != null && !(this.getDate() instanceof DateTime)) {
                throw new UnsupportedOperationException("TimeZone is not applicable to current value");
            }
            if (this.getDate() != null) {
                ((DateTime)this.getDate()).setTimeZone(timezone);
            }
            TzId tzId = new TzId(timezone.getID());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Replacing current timezone [" + this.getParameter("TZID") + "] with [" + tzId + "]"));
            }
            this.getParameters().replace(tzId);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Clearing timezone [" + this.getParameter("TZID") + "]"));
            }
            this.setUtc(this.isUtc());
        }
    }

    public final void setUtc(boolean utc) {
        if (this.getDate() != null && this.getDate() instanceof DateTime) {
            ((DateTime)this.getDate()).setUtc(utc);
        }
        this.getParameters().remove(this.getParameter("TZID"));
    }

    public final boolean isUtc() {
        if (this.getDate() instanceof DateTime) {
            return ((DateTime)this.getDate()).isUtc();
        }
        return false;
    }

    public void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("VALUE", this.getParameters());
        if (this.isUtc()) {
            ParameterValidator.getInstance().assertNone("TZID", this.getParameters());
        } else {
            ParameterValidator.getInstance().assertOneOrLess("TZID", this.getParameters());
        }
        Value value = (Value)this.getParameter("VALUE");
        if (this.getDate() instanceof DateTime) {
            if (value != null && !Value.DATE_TIME.equals(value)) {
                throw new ValidationException("VALUE parameter [" + value + "] is invalid for DATE-TIME instance");
            }
            DateTime dateTime = (DateTime)this.date;
            Parameter tzId = this.getParameter("TZID");
            if (!(dateTime.getTimeZone() == null || tzId != null && tzId.getValue().equals(dateTime.getTimeZone().getID()))) {
                throw new ValidationException("TZID parameter [" + tzId + "] does not match the timezone [" + dateTime.getTimeZone().getID() + "]");
            }
        } else if (this.getDate() != null) {
            if (value == null) {
                throw new ValidationException("VALUE parameter [" + Value.DATE + "] must be specified for DATE instance");
            }
            if (!Value.DATE.equals(value)) {
                throw new ValidationException("VALUE parameter [" + value + "] is invalid for DATE instance");
            }
        }
    }

    public Property copy() throws IOException, URISyntaxException, ParseException {
        Property copy = super.copy();
        ((DateProperty)copy).timezone = this.timezone;
        ((DateProperty)copy).setValue(this.getValue());
        return copy;
    }
}

