
# norootforbuild

Name:           open-xchange-usm
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  unzip, open-xchange-server == 6.18.0.0
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-1.5.0-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%if %{?fedora_version} <= 8
BuildRequires:  java-devel-icedtea saxon
%endif
%endif
Version:	6.18.0.0
%define		ox_release 14
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        Proprietary
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        The Open-Xchange Server USM Bundle
Requires:	open-xchange == 6.18.0.0
#

%description
The Open-Xchange Server USM Bundle

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true

make DESTDIR=%{buildroot} install

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles
%dir /opt/open-xchange/etc/groupware/osgi/bundle.d
%dir /opt/open-xchange/etc/groupware
%dir /opt/open-xchange/etc/admindaemon
/opt/open-xchange/bundles/*
/opt/open-xchange/etc/groupware/osgi/bundle.d/*
/opt/open-xchange/etc/admindaemon/osgi/bundle.d/*
%config(noreplace) /opt/open-xchange/etc/groupware/*.properties
%doc ChangeLog

%changelog
* Thu Oct 21 2010 - afe@microdoc.de
 - Bugfix #17321 - Activated new MeetingRequest algorithm for all devices except Nokia, added some fine-tuning to avoid problems with WinMob-devices
* Wed Oct 06 2010 - afe@microdoc.de
 - Bugfix - Adjusted GetAttachments command to retrieve correct attachment information
* Wed Sep 22 2010 - afe@microdoc.de
 - Bugfix #16816 - Added server config option to enable(default) or disable URL redirecting
* Fri Sep 17 2010 - ldo@microdoc.de
 - Bugfix #14654 - Bugfix 14654 copied from head
* Wed Sep 15 2010 - ldo@microdoc.de
 - Bugfix #16864 - NPE in ContentSyncerSupport
* Tue Sep 07 2010 - ldo@microdoc.de
 - bugfix #16451 copied from trunk
* Fri Aug 27 2010 - afe@microdoc.de
 - Workaround bug #16566 - Use different algorithm for determining request URL
 - Adjustment due to bug #14948 - urldecode image url sent by OX server
 - Bug #16566 - Added debug logging and message to client if MIME mail source can not be read
* Thu Aug 26 2010 - afe@microdoc.de
 - Disabled ContentTypeTransferHandler tests to avoid strange build problem in SLES10/IBM-JDK environment
* Mon Aug 02 2010 - choeger@open-xchange.com
 - Bugfix #16619 - USM package contains unnecessary bundle
* Wed Jul 28 2010 - afe@microdoc.de
 - Bugfix #16552 - Timezone from client that can be parsed, but not matched to a standard Timezone will be mapped to GMT instead
* Tue Jul 27 2010 - ldo@microdoc.de
 - send immediate changes after client creation to all protocols except EAS
 - send commands tag only if commands are really present 
* Tue Jul 27 2010 - afe@microdoc.de
 - Bugfix #16551 - Client used UUID reserved for server generated UUIDs
* Mon Jul 26 2010 - afe@microdoc.de
 - Bugfix #16569 - Added more detailed error message if sync failed due to conflicts
* Mon Jul 26 2010 - afe@microdoc.de
 - Bugfix #16527 - DateReceived for emails was sent in wrong format to EAS clients, causing problems with MailForExchange
* Thu Jul 22 2010 - ldo@microdoc.de
 - Bugfix #16401 - Do not send deleted exceptions in the deleted list in case of series (main attribute) modification
* Fri Jul 16 2010 - ldo@microdoc.de
 - Bugfix #16469 - Send error info mail to the client when invalid mail found on server
* Thu Jul 15 2010 - ldo@microdoc.de
 - Bugfix #16489 - Interface must not send stack traces to any client.
* Wed Jul 14 2010 - ldo@microdoc.de
 - Bugfix #16487 - Appointment exceptions have new uuid on each change from outlook. Added methods for remapping ox id to new uuid.
* Tue Jul 13 2010 - ldo@microdoc.de
 - Bugfix #16336 - timezone with same rules from clients should not overwrite timezone on server
* Mon Jul 12 2010 - ldo@microdoc.de
 - Bugfix #16438 - filter out empty contacts from the synchronization on mobile devices
* Wed Jul 07 2010 - afe@microdoc.de
 - Possible Bugfix #16451 - timezone of whole-day appointments is always sent as GMT, whole-day appointments are sent as ending 23:59:59 earlier (i.e. a single day appointment lasts only 1 second)
* Tue Jul 06 2010 - afe@microdoc.de
 - USMJSONServlet allows extra data (after ";") after the content-type
 - resolveIDs: Added specific error for bad UUIDs, optimized object lookup
* Mon Jul 05 2010 - afe@microdoc.de
 - Bugfix #16304 - Made old storeSyncState method available (deprecated) in case different bundle versions are in use
* Mon Jul 05 2010 - afe@microdoc.de
 - Bugfix #16450 - Enabled bugfix #15567 for all devices, not only iPhone
* Fri Jul 02 2010 - ldo@microdoc.de
 - New command: Retrieve OX Ids
* Fri Jul 02 2010 - afe@microdoc.de
 - Bugfix #16304 - Enhanced storage mechanism to allow to make sure to keep last used sync state also for complex operations
* Fri Jul 02 2010 - afe@microdoc.de
 - Bugfix #16407 - If an error occurs while reading headers and attachment data of a mail, those fields are reported as if empty
* Wed Jun 30 2010 - ldo@microdoc.de
 - bugfix #16414 - "days" should not be set to default value 127 when not sent by server
* Wed Jun 30 2010 - afe@microdoc.de
 - Added extended debug logging for bug 16304
* Tue Jun 29 2010 - afe@microdoc.de
 - Bugfix #16300 - Various optimizations regarding PIM attachments handling, some other small optimizations
* Tue Jun 29 2010 - ldo@microdoc.de
 - Bugfix #16336 - On Delete send status SUCCESS if the object is not found
* Tue Jun 29 2010 - afe@microdoc.de
 - Changed StringDataType so that null and "" are treated as equal (internally storing null for efficiency)
* Tue Jun 29 2010 - afe@microdoc.de
 - Changed use of StringDataType: Use constant instead of new instantiation for efficiency
* Mon Jun 28 2010 - ldo@microdoc.de
 - Bugfix #16403 - error from server on creating attachments should be reported to client
* Fri Jun 25 2010 - ldo@microdoc.de
 - bugfix #16392 - Saving emails in Drafts not possible (syncUpdate)
* Fri Jun 25 2010 - afe@microdoc.de
 - Optimized matching of contacts, added more detailed weighting to fields
* Fri Jun 25 2010 - afe@microdoc.de
 - Bugfix #16356 - Decode HTML-encoded characters from original mail in SmartForward/SmartReply
* Thu Jun 24 2010 - ldo@microdoc.de
 - bugfix #16388 - Attachments reduplicate when moving an appointment from one folder into another
* Thu Jun 24 2010 - afe@microdoc.de
 - Added matching of contacts based on identical/similar fields for slow sync
* Wed Jun 23 2010 - ldo@microdoc.de
 - bugfix #16377 - upsynced Folder reported as "created" in Downsync
* Tue Jun 22 2010 - ldo@microdoc.de
 - when client creates appointment with existing uid, the creation should be transformed to modification, or the uid in the client object should be changed 
* Mon Jun 21 2010 - ldo@microdoc.de
 - Bugfix #13960 - get server default changes after client creation and report them as modification to the client
* Mon Jun 21 2010 - ldo@microdoc.de
 - Bugfix #16297 - when getting resources, return error to client when resource not reachable or the server returned error page
* Fri Jun 18 2010 - ldo@microdoc.de
 - Bugfix #16352 - Attachments on appointment exceptions are not created when the exception is new to the server
* Thu Jun 17 2010 - ldo@microdoc.de
 - Bugfix #16343 - HTML response from server should not be searched for json regex pattern.
* Tue Jun 15 2010 - choeger@open-xchange.com
 - Bugfix #16329 - Missing dependency check at USM leads to non-working
   ActiveSync when updating with expired OXAE license; added version dependency
   to open-xchange
* Mon Jun 14 2010 - ldo@microdoc.de
 - Bug 16312 - implemented new script to build eas separately from usm
* Mon Jun 14 2010 - ldo@microdoc.de
 - Bugfix #16230 - NPE on change_exception with no recurrence_id set
* Mon Jun 14 2010 - afe@microdoc.de
 - Bugfix #16300 - Improve performance of syncs with many new objects
* Thu Jun 10 2010 - afe@microdoc.de
 - Added debug-logging of USM-JSON-requests with used time and number of OX-calls,similar to logging for EAS 
* Thu Jun 10 2010 - afe@microdoc.de
 - Bugfix: error in deserialization prevented correct setting of UUID from cached data for old serialized states 
* Thu Jun 10 2010 - afe@microdoc.de
 - Optimized uuid cache further: instead of String a simplified UUID is used as a key (reducing the cache key data to 128 bit and avoiding String operations when generating the key)
* Thu Jun 10 2010 - afe@microdoc.de
 - Fixed possible NPE when deleting objects
* Tue Jun 08 2010 - ldo@microdoc.de
 - Bugfix #16274 - null should not be sent to the server for boolean data types
* Tue Jun 08 2010 - ldo@microdoc.de
 - 2 PimAttachments objects are equal if both have empty attachments list. 
* Mon Jun 07 2010 - ldo@microdoc.de
 - Bugfix #16265 - Invalid attachment data should result in error with status 8
* Fri Jun 04 2010 - ldo@microdoc.de
 - Bugfix #16243 - check if the new folder tree implementation is installed before initializing a json session. (config: /modules/folder/tree) 
* Wed Jun 02 2010 - ldo@microdoc.de
 - Bugfix #16197 - attachments for client PIM Objects which still doesn't exist on server should not be read from server
* Wed Jun 02 2010 - afe@microdoc.de
 - Bugfix #16197(2) - attachments for client PIM Objects which still don't exist on server should not be read from server
* Tue Jun 01 2010 - ldo@microdoc.de
 - Allow emails without content-type and body
* Mon May 31 2010 - ldo@microdoc.de
 - Bugfix #16225 - simple data type should use JSONObject.NULL instead of null 
* Fri May 28 2010 - ldo@microdoc.de
 - Bugfix #13960 - get server defeult changes after client creation and report them as modification to the client
* Fri May 28 2010 - afe@microdoc.de
 - Added code to prevent multiple wrapping of exceptions which hides details of the original error 
* Fri May 28 2010 - afe@microdoc.de
 - Bugfix #16219 - birthdays are transferred as numbers
* Thu May 27 2010 - afe@microdoc.de
 - Bug #16170 - Disabled added feature for bug #15965
* Thu May 27 2010 - ldo@microdoc.de
 - Stack Trace in error message on Internal Error 
* Thu May 27 2010 - afe@microdoc.de
 - Reactivated folder access check before content is read 
* Thu May 27 2010 - ldo@microdoc.de
 - Bugfix #15060 Disallow changes to appointments shortly after a meetingresponse was received.
* Wed May 26 2010 - ldo@microdoc.de
 - Bugfix #16192 - Users are read from the user interface instead of GAL
* Wed May 26 2010 - ldo@microdoc.de
 - Bugfix #16195 - NPE on deleting PIM Attachments
* Tue May 25 2010 - ldo@microdoc.de
 - Bugfix #16028 - When renaming/moving email folder the ids of its subfolders should also be changed 
* Tue May 25 2010 - afe@microdoc.de
 - Disabled folder access check before content is read 
* Fri May 21 2010 - afe@microdoc.de
 - Bugfix #15799 - add all headers containing date/time JSONobjects correctly to sent mail
* Thu May 20 2010 - afe@microdoc.de
 - Modified ErrorStatusCode computation to match OX implementation of permission flags
* Wed May 19 2010 - afe@microdoc.de
 - Bugfix #16143 - Unhandled exceptions are now always logged with their stacktrace, JSONObjects are logged in formatted format for severe errors (OX,DB,Internal) if no exception is available 
* Wed May 19 2010 - afe@microdoc.de
 - Bugfix #16144 - ID field of "Groups" ContentType was not of data type String as expected by the USM
 - Bugfix #15965(10) - If properties of a folder are changed, the USM marks this folder as "needs to be synchronized" (which is normally done automatically since OX sends an event for that folder)
 - Bugfix #16131 - Use String instead of OXObjectID for cache keys to avoid deserialization problems for distributed caches
* Tue May 18 2010 - afe@microdoc.de
 - Bugfix - sorting of folders with null ids created NPE
 - Optimized sorting of folders
* Tue May 18 2010 - afe@microdoc.de
 - Bugfix #16142 - Folder read permissions are now checked before the folder content is read
 - Bugfix #16143 - If an exception is encapsulated in a JSONObject, that JSONObject is logged as a formatted String to provide a readable stacktrace
 - Added exception class name and exception message (if any) to errorDetails object
* Mon May 17 2010 - afe@microdoc.de
 - Bugfix #16113 - Creating multiple mails leads to error
* Wed May 12 2010 - afe@microdoc.de
 - Bugfix - incomplete sync (more server updates available) caused folders to be marked as synchronized
* Tue May 11 2010 - afe@microdoc.de
 - Bug #16084 - Possible workaround: EAS doesn't send empty Attachments-Tag any more
* Mon May 10 2010 - ldo@microdoc.de
 - "errors" in MoveItems should be JSONObject
* Fri May 07 2010 - afe@microdoc.de
 - Bugfix: Fixed error caused by incomplete handling of MeetingRequests for appointments that are already deleted
* Thu May 06 2010 - ldo@microdoc.de
 - Bugfix #16052 - Exception on moving a mail folder - not able to update cache
* Thu May 06 2010 - afe@microdoc.de
 - Bugfix #15515 - EAS Client iPhone doesn't display iso-8859-1x encoded mail bodies correctly
* Wed May 05 2010 - ldo@microdoc.de
 - Bugfix #16034 - DataObject should be included in the error message
* Wed May 05 2010 - afe@microdoc.de
 - Simplified configuration retrieval by adding convenience method to USM Session
 - Added access check for usm json access (dummy implementation in ox preferences module for now)
* Wed May 05 2010 - ldo@microdoc.de
 - Bugfix #16032 - For Move "Create Object" rights should be available in the destination folder, not "Write/Modify" rights
* Tue May 04 2010 - ldo@microdoc.de
 - Bugfix #16029 - created_by field doesn't exist in mail objects
* Tue May 04 2010 - afe@microdoc.de
 - Bugfix #16002 - faster discovery of changes in usm/eas access rights of an user
* Mon May 03 2010 - ldo@microdoc.de
 - Bugfix #15989 - Exception on reporting immediate server modification to a client creation
* Fri Apr 30 2010 - afe@microdoc.de
 - Bugfix #16005 - Appointment exceptions are not synced if series is not known to user
* Thu Apr 29 2010 - ldo@microdoc.de
 - MoveItems returns 7 new Error Status Codes for each not moved object
* Thu Apr 29 2010 - ldo@microdoc.de
 - MeetingRequest: parent Folder can not be determined - get all appointments from the server, and search for the one in the meeting request
* Thu Apr 29 2010 - ldo@microdoc.de
 - Bugfix #15990 - Changes in Exception to Series Appointments should be reported to client
* Tue Apr 27 2010 - ldo@microdoc.de
 - MoveItems returns 4 new Response Status Codes: 13 - dest. doesn't exist, 14 - source doesn't exist, 15 - dest. no permiss., 16 - source no permiss.
* Tue Apr 27 2010 - ldo@microdoc.de
 - Bugfix #15890 - created mail folders should have the same uuid on the same syncid and different http-sessionid
* Mon Apr 26 2010 - ldo@microdoc.de
 - Bugfix #15567 - mails have wrong timestamp on iphone - local time instead of UTC sent in DateReceived
* Thu Apr 22 2010 - ldo@microdoc.de
 - Bugfix #15911 - "number_of_attachments" should not be sent to server because it is set automatically from server
* Thu Apr 22 2010 - ldo@microdoc.de
 - Bugfix #15925  - Errors in MoveItems command should contain uuid and the error JSONObject
* Thu Apr 22 2010 - ldo@microdoc.de
 - Bugfix #15909 - Create change and delete exceptions to series appointments in one update call 
* Wed Apr 21 2010 - ldo@microdoc.de
 - Distribution member list has display_name field instead of first_name and last_name
* Tue Apr 13 2010 - ldo@microdoc.de
 - Bugfix #15802 - parameter "force" used on saving emails in inbox
* Wed Apr 07 2010 - ldo@microdoc.de
 - Bugfix #15798 - All multipart message types should be supported 
* Tue Mar 30 2010 - ldo@microdoc.de
 - Meeting Request enabled 
* Mon Mar 29 2010 - ldo@microdoc.de
 - QoutedInternetAddress class from server is used to build addresses in the JSON to MIME conversion
* Thu Mar 25 2010 - ldo@microdoc.de
 - Bugfix #15676 ConfirmindParticipant should overwrite equals
* Wed Mar 24 2010 - ldo@microdoc.de
 - Bugfix #15560 mails marked as deleted as should be filtered out for the EAS protocol
* Wed Mar 24 2010 - ldo@microdoc.de
 - Bugfix #15661 - On rename of email folders from Client the new ID of the folder should be saved in the DB 
* Tue Mar 23 2010 - ldo@microdoc.de
 - Bugfix #15425 - Sending the Appointment Note as Body in a Meeting Request mail
* Tue Mar 23 2010 - ldo@microdoc.de
 - Bugfix #15425 - workaround activated just for iPhone
* Tue Mar 23 2010 - ldo@microdoc.de
 - Whole-day appointment exceptions should be sent in local time  
* Mon Mar 22 2010 - ldo@microdoc.de
 - When the user has no read rights on a folder, the sync system should set this folder as empty
* Fri Mar 19 2010 - ldo@microdoc.de
 - Distribution List Member UUID from client should be mapped to OX-id 
* Thu Mar 18 2010 - ldo@microdoc.de
 - Bugfix #15622 - Start/End time for Whole-day appointments should not be sent in UTC
* Thu Mar 18 2010 - ldo@microdoc.de
 - Usage of mail.mime.ContentType and mail.mime.ContentDisposition classes from server
* Thu Mar 18 2010 - ldo@microdoc.de
 - Distribution List Member should have a UUID 
* Wed Mar 17 2010 - ldo@microdoc.de
 - Bug #15608 - Error on editing Mails from Client - editing of 2 mails at once
* Tue Mar 16 2010 - ldo@microdoc.de
 - Bug #15613: Non-ASCII characters in Mail Subject show up on server as ?
* Tue Mar 16 2010 - ldo@microdoc.de
 - Bug #15609 - On moving Mails Inbox - Trash sync reports the email twice as deleted
* Mon Mar 15 2010 - ldo@microdoc.de
 - All mail headers received from Client should be sent to the server in the MIME-Mail
* Mon Mar 15 2010 - ldo@microdoc.de
 - Content-Type params should be a quoted String in case they contain empty spaces
* Mon Mar 15 2010 - ldo@microdoc.de
 - ContactDistributionMember doesn't always have user_id 
* Fri Mar 12 2010 - ldo@microdoc.de
 - Params for header "content-type" made optional
 - Address headers (as defined in Spez.) and simple headers: "thread-thopic", "thread-index", "importance" added
 - Text - Body (text/plain) should not be expected as Base64 encoded if "content-transfer-encoding": "base64" is not set
* Thu Mar 11 2010 - ldo@microdoc.de
 - On Status 4 (Internal Error) the StackTrace should be sent to the Client
* Wed Mar 10 2010 - ldo@microdoc.de
 - Occurrences (222) field in Tasks should be synchronized 
* Wed Mar 10 2010 - ldo@microdoc.de
 - PIMAttachments deletion: on delete is not always the lastModifiedOfNewestAttachmentUTC changed, but sometimes only the number_of_attachments field
 - PIMAttachments deletion: when all attachments are deleted on the server, the field lastModifiedOfAttachmentUTC is reset to null 
* Wed Mar 10 2010 - ldo@microdoc.de
 - SyncUpdate: creation of new mails in syncUpdate should be possible
* Tue Mar 09 2010 - ldo@microdoc.de
 - PingHandler: context_uuid should be handled differently as other folder-uuids
* Mon Mar 08 2010 - ldo@microdoc.de
 - EAS Mail Attachments - attachments should be sent in the Change result
* Tue Mar 02 2010 - ldo@microdoc.de
 - UUIDs for Emails - do not send random UUIDs if the Email has already been synchronized
* Mon Mar 01 2010 - ldo@microdoc.de
 - USM, EAS Preferences Item Service
* Mon Mar 01 2010 - afe@microdoc.de
 - Bugfix #15510: Fixed off-by-1 error in conversion of serialized data
* Mon Mar 01 2010 - ldo@microdoc.de
 - EAS Mail Attachments
* Fri Feb 26 2010 - ldo@microdoc.de
 - "All" option added to SetConfiguration command - Documentation
* Thu Feb 25 2010 - ldo@microdoc.de
 - Meeting Request disabled
* Thu Feb 25 2010 - ldo@microdoc.de
 - "All" option added to SetConfiguration command
* Wed Feb 24 2010 - ldo@microdoc.de
 - Index of Attachments field in Contacts should be calculated relatively to Image fields
* Tue Feb 23 2010 - ldo@microdoc.de
 - double usage of error codes removed
 - pim attachments and exceptions code can be skipped for groups and resources
* Tue Feb 23 2010 - ldo@microdoc.de
 - Elements of Content Type Dummy Folders should not be removed from cache on syncUpdate on the Folder Hierarchy
* Tue Feb 23 2010 - afe@microdoc.de
 - Changed MoveItemsHandler to report conflicts like SyncInit and SyncUpdate
* Tue Feb 23 2010 - ldo@microdoc.de
 - Added field "timezone" to Calendar
* Mon Feb 22 2010 - ldo@microdoc.de
 - use user's timezone - just for AllDay Events
* Fri Feb 19 2010 - ldo@microdoc.de
 - US4158: Use timezone=UTC parameter in all OX-Calls
* Thu Feb 18 2010 - ldo@microdoc.de
 - DataTypes for complex Objects should return a default value in case the JSON value is NULL
* Thu Feb 18 2010 - ldo@microdoc.de
 - JSON_API_Definition document changed
* Wed Feb 17 2010 - ldo@microdoc.de
 - allowed_modules parameter in all OX-folder-calls is created from the currently (in the current session) supported content types 
* Wed Feb 17 2010 - ldo@microdoc.de
 - Resources (read only) implementation
* Wed Feb 17 2010 - ldo@microdoc.de
 - For Unsupported Content Operations the error details should not contain a stacktrace
* Mon Feb 15 2010 - afe@microdoc.de
 - tree-parameter is no longer sent on OX-folder calls if the value is empty
* Fri Feb 12 2010 - ldo@microdoc.de
 - Meeting Request: send the folder uuid in the meeting_request object
* Fri Feb 12 2010 - ldo@microdoc.de
 - Groups and Resources (read only) implementation
* Fri Feb 12 2010 - afe@microdoc.de
 - Added new parameter allowed_modules to OX-folder-calls, disabled temporary OX-folder2-calls
* Thu Feb 11 2010 - ldo@microdoc.de
 - Added new fields to Appointments (uid, organizer, sequence, confirmations)
* Wed Feb 10 2010 - afe@microdoc.de
 - Fixed problem in TaskContentType compatibility code that prevented correct deserialization of all fields 
* Wed Feb 10 2010 - ldo@microdoc.de
 - Fixed problem in limiting the sync results which caused series to be sent without their exceptions and empty results when trying to send exceptions to unknown series
* Wed Feb 10 2010 - ldo@microdoc.de
 - PIM Attachments: attachments should not be requested from server when the "attachments" field is not set for synchronization
* Tue Feb 09 2010 - ldo@microdoc.de
 - PIM Attachments: removed the effect of false server modification on syncUpdate caused of wrong timestamp received on create and delete attachments 
* Mon Feb 08 2010 - ldo@microdoc.de
 - PIM Attachments: lastModifiedOfAttachments field available on server - made according changes
 - Meeting Requests: first implementation; meeting_request field is set on reading meeting request emails
* Mon Feb 08 2010 - ldo@microdoc.de
 - PIM Attachments for Appointment Exceptions
* Thu Feb 04 2010 - afe@microdoc.de
 - Modified parsing of limit parameter to allow for limit 0
* Thu Feb 04 2010 - ldo@microdoc.de
 - Repeated folder creation calls with same syncId should be ignored
* Wed Feb 03 2010 - ldo@microdoc.de
 - PIMAttachments handling
 - Refactored creating of appointment exceptions (too many sync states were saved) 
* Wed Feb 03 2010 - ldo@microdoc.de
 - JSON_API_Definition document changed: added PIM Attachments. 
* Tue Feb 02 2010 - ldo@microdoc.de
 - PIMAttachments handling
* Mon Feb 01 2010 - afe@microdoc.de
 - Added parameters to OX login call to identify the USM, sub-protocol and session
* Mon Feb 01 2010 - afe@microdoc.de
 - Added check when reading which fields to synchronize from DB to avoid invalid fields due to changes in ContentTypes
* Mon Feb 01 2010 - afe@microdoc.de
 - Bugfix #15268: Added workaround for incomplete Nokia N900 (and possibly Android) authorization
* Fri Jan 29 2010 - ldo@microdoc.de
 - PIMAttachments handling
* Fri Jan 29 2010 - afe@microdoc.de
 - Removed invalid tasks field 'project_id', added code that allows deserialization of old SyncState data
* Fri Jan 29 2010 - afe@microdoc.de
 - Fixed problem in contact-image-generation
* Fri Jan 29 2010 - ldo@microdoc.de
 - changed the json tests for tasks to fit the new tasks content type (field project_id removed)
* Thu Jan 28 2010 - afe@microdoc.de
 - Made TransferHandlers more tolerable regarding numbers sent from OX: Now also Strings that can be parsed to doubles are allowed
* Wed Jan 27 2010 - afe@microdoc.de
 - Bugfix #15270: Fixed SQL constraint error that could occur if too many new session were created at once
* Tue Jan 26 2010 - afe@microdoc.de
 - Enhanced automatic test client support classes
* Mon Jan 25 2010 - ldo@microdoc.de
 - PIMAttachments handling
* Tue Jan 19 2010 - afe@microdoc.de
 - Changed birthday field from date to number so that no conversion from/to user timezone for OX data is performed
 - Changed mapping for birthday field so that parsing of date is correctly performed
* Tue Jan 19 2010 - ldo@microdoc.de
 - Added methods for creating/retrieving/deleting PIM Attachments on the OX Server
* Tue Jan 19 2010 - ldo@microdoc.de
 - Bug #15142: workaround enabled for all devices except iPhone
* Mon Jan 18 2010 - ldo@microdoc.de
 - Bug #15142 - Previously created exception is reset when creating another exception on Nokia Devices
* Fri Jan 15 2010 - ldo@microdoc.de
 - Unsupported folders should not be returned in the ping result as changed.
* Fri Jan 15 2010 - ldo@microdoc.de
 - ping properties renamed
 - JSONArray method usage removed because it is not available in the OX json implementation
* Fri Jan 15 2010 - afe@microdoc.de
 - Extended deserialization mechanism to allow migration from old serialized data to current format
 - Added objects for PIM attachment management and basic fields for future communication with OX server
 - Streamlined code for ContentTypes by implementing common abstract base classes for ContentTypes and their service wrappers
* Thu Jan 14 2010 - ldo@microdoc.de
 - Ping Command Implementation
* Tue Jan 12 2010 - afe@microdoc.de
 - Added userid to response of login and getConfiguration commands, added JSON-API-specification documents to SVN repository
* Tue Jan 12 2010 - ldo@microdoc.de
 - Bug #15142 - Previously created exception is reset when creating another exception on Nokia Devices
* Tue Jan 12 2010 - ldo@microdoc.de
 - Bug #15157 - Contact field mapping switched for "E-Mail" fields
* Tue Jan 12 2010 - afe@microdoc.de
 - Bugfix: SendMail with multi-line From-Header caused request to be aborted
* Mon Jan 11 2010 - ldo@microdoc.de
 - Bug #15154 - New contacts are not synchronized to the server
* Fri Dec 18 2009 - ldo@microdoc.de
 - Deleting contact images
* Fri Dec 18 2009 - afe@microdoc.de
 - Changed behavior of MeetingRequest: Only sent if header "X-Open-Xchange-Type: New" is present and if user hasn't set his status yet
* Thu Dec 17 2009 - ldo@microdoc.de
 - Mails on slow sync - handle different conflict resolution scenarios for structured mail objects
* Wed Dec 16 2009 - afe@microdoc.de
 - Optimized some internal code
* Tue Dec 15 2009 - ldo@microdoc.de
 - When changing email body, first create the new email, and than delete the old one on the server
* Tue Dec 15 2009 - afe@microdoc.de
 - Optimized internal class for NestedMail-property storage
* Tue Dec 15 2009 - ldo@microdoc.de
 - Refactoring: changes as suggested from FindBugs
* Tue Dec 15 2009 - afe@microdoc.de
 - Bug #15072: Added workaround for WinMob problem with empty categories
* Tue Dec 15 2009 - ldo@microdoc.de
 - MimeMailBuilder should be able to convert messages with attachment as returned form OX Server
* Fri Dec 11 2009 - ldo@microdoc.de
 - Client should not be able to send objects in a Sync command from a folder different than the one currently synchronized  
* Fri Dec 11 2009 - ldo@microdoc.de
 - ConflictingChangeException should be thrown when OX returns error because of Edit Conflict
* Thu Dec 10 2009 - ldo@microdoc.de
 - Harddelete for Mails used in the USM_JSON
 - MoveItems should return Conflicting errors (as exception) in case of conflicts between client and server 
* Thu Dec 10 2009 - afe@microdoc.de
 - US3853: Added new version parameter and result to login command
* Wed Dec 09 2009 - afe@microdoc.de
 - Added new parameter ConflictResolution to sync-methods in Session API to optionally specify the ConflictResolution for a specific sync-call
* Wed Dec 09 2009 - ldo@microdoc.de
 - Send all Appointment Exceptions (change and delete) always and in both directions (Client to Server and Server to Client)
* Mon Dec 07 2009 - ldo@microdoc.de
 - Move Items implementation
* Fri Dec 04 2009 - ldo@microdoc.de
 - Added new method to MailContentType to delete email permanently from Server
* Fri Dec 04 2009 - afe@microdoc.de
 - Extended DB access and JMX interface so that now operations can be performed on all OX contexts (if 0 is provided as context)
* Fri Dec 04 2009 - afe@microdoc.de
 - Modified OX-access code so that resource URLs with parameters will now be correctly handled (not URL-encoded again).
* Wed Dec 02 2009 - afe@microdoc.de
 - Extended Session API (getParentFolder(), new TimestampMismatchException), added constant for "no limit on reported server changes"
 - Changed behavior of Incremental- and SlowContentSyncer: An error during server updates no longer aborts the sync, but is stored and reported back in the SyncResult. The Sync is completed successfully even if errors during updates occurred
 - Updated EAS methods to use modified SessionAPI
* Tue Dec 01 2009 - afe@microdoc.de
 - Added constant to Session API for no limit on SyncResult size
 - Added code to SlowContentSyncer and IncrementalContentSyncer to handle UUID matches and repeated creations from clients
* Fri Nov 27 2009 - afe@microdoc.de
 - Bugfix #14994: Changed Fetch-command so that now complete MIME body is returned regardless of MIMETruncation, and if no MIMESupport is enabled, the complete body is returned regardless of Truncation
* Thu Nov 26 2009 - ldo@microdoc.de
 - Configuration for the email fields which need to be synchronized 
* Thu Nov 26 2009 - ldo@microdoc.de
 - Retrieve the email as Structured JSON Object from server
* Wed Nov 25 2009 - afe@microdoc.de
 - Added code to session management and SlowContentSyncer to detect uuid conflicts for slow syncs
* Wed Nov 25 2009 - ldo@microdoc.de
 - Handling of Client mail creations as StructuredJSONMailObject
* Wed Nov 25 2009 - afe@microdoc.de
 - Bugfix #14983: Added missing tables to CreateTableService
* Tue Nov 24 2009 - afe@microdoc.de
 - Add start_date only for full_time appointment series, never add delete_exceptions on updates
* Tue Nov 24 2009 - afe@microdoc.de
 - Bug #14970: Workaround for WinMob crashes: Only write body tag for email if the body is not empty
* Tue Nov 24 2009 - afe@microdoc.de
 - UUID database storage activated
* Tue Nov 24 2009 - afe@microdoc.de
 - Fixed problem where picture data was not sent on server updates for contacts
* Mon Nov 23 2009 - afe@microdoc.de
 - Added temporary workaround for Bug #14952 to avoid NPE in OX server code
* Fri Nov 20 2009 - ldo@microdoc.de
 - Exception from Series - creating, modifying and deleting from the JSON API 
* Fri Nov 20 2009 - afe@microdoc.de
 - Removed unnecessary recurrence_id for appointment calls to the OX server 
* Fri Nov 20 2009 - ldo@microdoc.de
 - Comparator for Folder Hierarchy 
* Thu Nov 19 2009 - afe@microdoc.de
 - Fixed problem in unnecessary field removal which caused too many fields to be removed for new exceptions
* Thu Nov 19 2009 - afe@microdoc.de
 - Fixed problem with client changes on series exceptions that were moved to a different date
* Thu Nov 19 2009 - afe@microdoc.de
 - Added workaround for endless yearly series (clients may automatically limit until-times that the server sent)
* Wed Nov 18 2009 - afe@microdoc.de
 - Added new field 316 (standard_folder_type) to FolderContentType
* Wed Nov 18 2009 - afe@microdoc.de
 - Removed unnecessary request body fields for updates on appointment series
* Wed Nov 18 2009 - afe@microdoc.de
 - Added UpdateTask with version 93 that clears all cache tables
* Tue Nov 17 2009 - ldo@microdoc.de
 - workaround : remove all exceptions which do not have recurrence_date_position in order to avoid sending illegal data to devices
* Tue Nov 17 2009 - choeger@open-xchange.com
 - Bugfix #14882:  USM svn revision not shown in logfile
* Tue Nov 17 2009 - afe@microdoc.de
 - Removed package reference to com.openexchange.push in the EventListener
* Tue Nov 17 2009 - afe@microdoc.de
 - Changed OXJSONAccessImpl: HTTP redirects for OX access (up to 10 levels) are followed, an INFO message is logged every 5 minutes as long as redirects are active
* Mon Nov 16 2009 - afe@microdoc.de
 - Bugfix #14639 - Added optional authentication for OPTIONS command
* Mon Nov 16 2009 - afe@microdoc.de
 - Bugfix #14854: Modified OXEventListener so that delete events that do not use DataObjects do not cause ClassCastExceptions
* Mon Nov 16 2009 - afe@microdoc.de
 - Changed Headers data type so that correct JSONArray of Strings is generated for headers with multiple values
* Mon Nov 16 2009 - ibr@microdoc.de
 - Bugfix #14853: set explicitly the WBXML codepage (the namespace) in CategoriesOperationXmlType to avoid the exception by implicitly change of codepage with multiple possibilities
* Fri Nov 13 2009 - afe@microdoc.de
 - Added getContextUUID() method to USM Session API
* Thu Nov 12 2009 - afe@microdoc.de
 - Modified deserialization error handling: Errors are caught at low level and bad sync states are reported as not available
* Thu Nov 12 2009 - ibr@microdoc.de
 - Change the class Header for multiple headers from Map<String, String> to Map<String, String[]>, change tests
* Thu Nov 12 2009 - ibr@microdoc.de
 - Change  NestedMail for filename field, from Map<ContentTypeField, Object> to Map<String, Object>
* Wed Nov 11 2009 - ldo@microdoc.de
 - Bugfix #14644 - Remove deprecated fields (links 591)
* Tue Nov 10 2009 - ldo@microdoc.de
 - Virtual folders - Folder.Tree persistent session field; tree parameter in all OX requests to the folder module 
* Tue Nov 10 2009 - afe@microdoc.de
 - Added JMX interface for SessionManager that allows monitoring the active sessions and monitoring/changing configuration parameters and persistent session properties 
* Tue Nov 10 2009 - afe@microdoc.de
 - Added simple logging of EAS session activity (first and last access time) in the database
 - Added session-specific debug logging to standard log mechanism (can be enabled via the session JMX interface)
* Tue Nov 10 2009 - ldo@microdoc.de
 - Bugfix #14644 - Remove deprecated fields (number_of_links  103; after_complete   304)
* Thu Nov 05 2009 - ldo@microdoc.de
 - Automated fetch test
* Thu Nov 05 2009 - ldo@microdoc.de
 - Automated send email test
* Thu Nov 05 2009 - ldo@microdoc.de
 - Automated tests 
* Thu Nov 05 2009 - ldo@microdoc.de
 - Bugfix #13979 - Appointment participants are always added as external participants
* Wed Nov 04 2009 - afe@microdoc.de
 - Added projects for release-packages and automated test classes
* Wed Nov 04 2009 - ldo@microdoc.de
 - Automated delete test
* Tue Nov 03 2009 - ibr@microdoc.de
 - Change by MailContentTypeTransferHandlerImpl: method getMailAttachment
* Tue Nov 03 2009 - ldo@microdoc.de
 - Delete objects from UUID mapping table on receiving delete event from the OX server
* Fri Oct 30 2009 - ldo@microdoc.de
 - Added update task for the tables used in UUID management
* Thu Oct 29 2009 - afe@microdoc.de
 - Added configuration property com.openexchange.usm.eas.meeting_request_enabled
 - Disabled persistent storage of EAS UID fields in the DB
* Wed Oct 28 2009 - afe@microdoc.de
 - Bugfix #14729 - Modified USMOXDeleteListener so that no DeleteFailedException is thrown if USM tables do not exist
* Mon Oct 26 2009 - afe@microdoc.de
 - Bugfix #14663 - Sync for series with exceptions could fail because wrong time filter was used when determining all occurrences of the series (only temporary workaround for now)
* Fri Oct 23 2009 - afe@microdoc.de
 - Added new Exception for deserialization errors to improve logged information in case DB inconsistency occurs
* Tue Oct 20 2009 - afe@microdoc.de
 - Bugfix #14680 - large appointment body causes invalid "BodySize" tag to be written (only valid for Mail and Tasks)
* Mon Oct 19 2009 - afe@microdoc.de
 - Added code to enable sync system to read in sync states from DB in old format (in case the UpdateTask was not executed) 
* Fri Oct 16 2009 - ldo@microdoc.de
 - bug fix 14661 - "days" should not be set for yearly appointment 
* Wed Oct 14 2009 - afe@microdoc.de
 - Added code to make sure HttpStatus 401 is returned if authentication fails
* Tue Oct 13 2009 - afe@microdoc.de
 - Added method to DataType to check for default value
* Fri Oct 09 2009 - afe@microdoc.de
 - Added UpdateTask that completely empties all USM cache tables (required for changed cache storage with UUIDs)
* Thu Oct 08 2009 - afe@microdoc.de
 - Modified UUID mapping and test to allow global UUIDs
* Thu Oct 08 2009 - afe@microdoc.de
 - Modified EAS code to work with global UUID mapping
* Wed Oct 07 2009 - afe@microdoc.de
 - Added new FolderNotFoundException that is thrown if a given folderid can not be mapped to an OX folder
 - Added findFolder method to Session
 - Changed limit to generate DB map entry for long folder ids to allow 20 character OX object IDs without extra mapping 
* Wed Oct 07 2009 - afe@microdoc.de
 - Added methods to Session interface to allow UUID mapping, added simple test implementation for uuid mapping
* Tue Oct 06 2009 - ldo@microdoc.de
 - Parameter view = "text" set when getting email as forward/reply
* Tue Oct 06 2009 - ldo@microdoc.de
 - bug fix 14564
* Mon Oct 05 2009 - afe@microdoc.de
 - Split internal OX access API login method into login and getConfiguration 
* Tue Sep 29 2009 - afe@microdoc.de
 - Added Session API method that returns view of persistent fields
* Mon Sep 28 2009 - afe@microdoc.de
 - Bugfix #14589, #14575: Fixed hashCode()/equals() problem with ContentTypes on J9 JVMs
* Mon Sep 28 2009 - afe@microdoc.de
 - Bugfix #14598: Changed X-header USM version to match that of OX head
 - Bugfix #14598: Changed X-header EAS version to match that of OX head
* Fri Sep 25 2009 - afe@microdoc.de
 - Bugfix #14575: Added code to ensure that content type filters are always set and no NPE is thrown
* Fri Sep 25 2009 - afe@microdoc.de
 - Bugfix #14569: Improved conversion from/to binary timezone structure, added fallback to simple TimeZone if conversion is not possible
* Fri Sep 25 2009 - afe@microdoc.de
 - Bugfix #14573: Modified UpdateTask to correctly work with partially installed sequences
* Wed Sep 23 2009 - afe@microdoc.de
 - Bugfix #14552: Removed unnecessary debug logging of a stacktrace in case an EAS device does not send all required parameters
* Tue Sep 22 2009 - ldo@microdoc.de
 - end synchronization on logout in USM JSON API
* Tue Sep 22 2009 - ldo@microdoc.de
 - end synchronization on logout in USM JSON API - remove session from internal storage
* Mon Sep 21 2009 - afe@microdoc.de
 - Bugfix #14469: Workaround for internal error on WinMob-devices for mails with empty subject
* Fri Sep 18 2009 - afe@microdoc.de
 - Enhancement: Added possibility to limit the number of mails in a folder for a sync
 - Enhancement: Added property "com.openexchange.usm.eas.mail.limit" to limit mails in folder for sync
 - Bugfix: Fixed possible NPE for simultaneous client and server deletion
* Thu Sep 17 2009 - ldo@microdoc.de
 - Error handling in the USM-JSON API
* Wed Sep 16 2009 - afe@microdoc.de
 - Bugfix #14522: Fixed typo in SQL query in USMDeleteListener, ensured correct usage of contextid
* Tue Sep 15 2009 - afe@microdoc.de
 - Bugfix #14509: Possible NPE on changes in calendar entries
* Thu Sep 10 2009 - afe@microdoc.de
 - Added regularly updates of persistent data from DB in case an external change occurs
* Thu Sep 10 2009 - afe@microdoc.de
 - General code cleanup of some internal EAS classes
* Wed Sep 09 2009 - afe@microdoc.de
 - Bugfix #14480: Categories for exceptions in series were not generated correctly
* Tue Sep 08 2009 - afe@microdoc.de
 - Merged USM- and EAS-ChangeLog into global ChangeLog
* Mon Sep 07 2009 - afe@microdoc.de
 - Added new config property "com.openexchange.usm.eas.mail.time_limit" that imposes an extra limit for mail synchronization (default value: 3 days)
* Mon Sep 07 2009 - afe@microdoc.de
 - Bugfix #14459: minimized usage time of SQL connection by rearranging code, using read-only connections where possible
* Fri Sep 04 2009 - afe@microdoc.de
 - Bugfix #14448: USM/EAS now always explicitly sets the From:-header when sending an email (overwriting any From:-header specified by the device)
* Thu Sep 03 2009 - ldo@microdoc.de
 - Set the right timestamp when deleting more than one exception 
* Wed Sep 02 2009 - ldo@microdoc.de
 - "days" field should always be sent when updating series
* Wed Sep 02 2009 - ldo@microdoc.de
 - Added relevant fields in appointment which change causes exceptions to be deleted
* Tue Sep 01 2009 - ldo@microdoc.de
 - Bugfix #14416: Nokia: Private flag gets overwritten  
* Tue Sep 01 2009 - ldo@microdoc.de
- Bugfix #14366: Changes on series exceptions are not synchronized   
* Tue Sep 01 2009 - afe@microdoc.de
 - Fixed typo in API method name
* Tue Sep 01 2009 - afe@microdoc.de
 - Fixed typo in API method name
* Tue Sep 01 2009 - choeger@open-xchange.com
 - Bugfix #14408: Changelog is not contained /usr/share/doc/open-xchange-usm
* Mon Aug 31 2009 - afeo@microdoc.de
 - modified new log message to report commands without an USM session or OX calls 
* Fri Aug 28 2009 - ldo@microdoc.de
 - change the time of a series with exceptions should be sent to clients as delete + add  
* Fri Aug 28 2009 - ldo@microdoc.de
 - added special log message for request duration time 
* Fri Aug 28 2009 - afe@microdoc.de
 - Modified the Session-API so that also empty custom SyncStates can be stored (but only syncStates for FolderContent)
* Fri Aug 28 2009 - afe@microdoc.de
 - Added code to collect per-session statistics on how much time is spent in how many OX-calls
* Tue Aug 25 2009 - afe@microdoc.de
 - Changed access check code and default values to reflect new properties as discussed by mail
* Tue Aug 25 2009 - ldo@microdoc.de
 - Bugfix #14371: Ending the series on iPhone when trying to make a change "for all future" occurrences
* Tue Aug 25 2009 - afe@microdoc.de
 - Changed access check code of USM/EAS to use new properties as discussed by mail
* Tue Aug 25 2009 - ldo@microdoc.de
 - Bugfix #14371: Ending the series on iPhone when trying to make a change "for all future" occurrences
* Mon Aug 24 2009 - ldo@microdoc.de
 - Bugfix #14366: We are using the Exception ID for updating exceptions, and not the Master ID
* Mon Aug 24 2009 - ldo@microdoc.de
 - Bugfix #14369: Mapping of BusyStatus corrected
* Fri Aug 21 2009 - afe@microdoc.de
 - Bugfix #14355: Removed optional DayOfWeek parameter for daily series
* Thu Aug 20 2009 - afe@microdoc.de
 - Added new Session API method to allow protocols to store custom sync states if synchronization can only be partially completed
* Thu Aug 20 2009 - ldo@microdoc.de
 - Bugfix #14220: old exceptions should be removed from the response when they are deleted as a result of changint the start time of the series.
* Thu Aug 20 2009 - afe@microdoc.de
 - Bugfix #14191: Added automatic addition of display name to From:-header if only simple email address is present when sending an email
* Wed Aug 19 2009 - ldo@microdoc.de
 - Bugfix #14275: Modification of series appointment structure is not synchronized
* Wed Aug 19 2009 - afe@microdoc.de
 - Reenabled MeetingRequests due to unresolved problems
 - Added specialized warning log message that is generated instead of default error
   if an I/O error occurs while sending the result of a command to the device (indicating a problem in the device or the network)
* Wed Aug 19 2009 - ldo@microdoc.de
 - Bugfix #14275: Modification of series appointment structure is not synchronized - deletion of single appointments
* Wed Aug 19 2009 - afe@microdoc.de
 - Bugfix #13999: Suppress invitation emails from iPhone and WinMob devices when creating an appointment
* Wed Aug 19 2009 - ldo@microdoc.de
 - Bugfix #14275: Modification of series appointment structure is not synchronized
* Wed Aug 19 2009 - afe@microdoc.de
 - Bugfix #14278: using all/list request combo for mail synchronization with timeframe instead of single large all request
* Wed Aug 19 2009 - ldo@microdoc.de
 - Bugfix #14275: Modification of series appointment structure is not synchronized - deletion of single appointments
* Tue Aug 18 2009 - afe@microdoc.de
 - USM ChangeLog created
* Tue Aug 18 2009 - afe@microdoc.de
 - Moved configuration properties for EAS into a new properties file (eas.properties), added new file to build system
 - Changed stand-alone ConfigurationManager so that it reads in all files (*.properties) in the config folder,
   reporting warnings if a property is set multiple times
* Tue Aug 18 2009 - afe@microdoc.de
 - EAS ChangeLog created
* Tue Aug 18 2009 - afe@microdoc.de
 - Completely disabled generation of MeetingRequests
* Wed Jul 01 2009 - choeger@open-xchange.com
 - Bugfix #14041: Debian package contains to many USM bundles
