/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.uuid.impl;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

import junit.framework.TestCase;

import org.apache.commons.logging.Log;

import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.database.EncapsulatedConnection;
import com.openexchange.usm.api.exceptions.USMSQLException;
import com.openexchange.usm.cache.SimCacheManager;
import com.openexchange.usm.journal.SimLog;
import com.openexchange.usm.uuid.OXObjectID;
import com.openexchange.usm.uuid.SimDatabaseAccessManager;
import com.openexchange.usm.uuid.exceptions.OXObjectAlreadyMappedException;
import com.openexchange.usm.uuid.exceptions.UUIDAlreadyMappedException;

public class UUIDMappingImplTest extends TestCase {

	SimDatabaseAccessManager _dbManager = new SimDatabaseAccessManager();
	Log _journal = new SimLog();
	EncapsulatedConnection _con;
	UUIDMappingImpl _mapper;
	int _contextId = 1;

	@Override
	protected void setUp() throws Exception {
		_con = _dbManager.getWritable(_contextId);
		Statement statement = _con.createStatement();
		try {
			statement
					.executeUpdate("create table UUIDMapping(cid integer NOT NULL, contentType  integer NOT NULL, objectId  integer NOT NULL, uuid binary(16) NOT NULL);");
			statement
					.executeUpdate("create unique index UUIDMappingUIDX on UUIDMapping (cid, contentType, objectId, uuid)");
			statement.close();
		} catch (SQLException e) {
			e.printStackTrace();
			fail(e.getMessage());
		} finally {
			statement.close();
		}
		_mapper = new UUIDMappingImpl();
		_mapper.activate(_journal, _dbManager, new SimCacheManager());
	}

	public void testGetUUID() {
		int cid = _contextId;
		int objectId = 100;
		int contentType = 5;
		try {
			UUID uuid = _mapper.getUUID(cid, contentType, objectId);
			if (uuid == null)
				fail("No uuid generated");
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}
	}

	public void testStoreMapping() {
		int cid = _contextId;
		int objectId = 100;
		int contentType = 5;
		OXObjectID oxObjectId = new OXObjectID(cid, contentType, objectId);
		UUID uuid = UUID.randomUUID();
		try {
			_mapper.storeMapping(uuid, oxObjectId);
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		} catch (OXObjectAlreadyMappedException e) {
			fail(e.getMessage());
		} catch (UUIDAlreadyMappedException e) {
			fail(e.getMessage());
		}

		try {
			UUID newUUID = UUID.randomUUID();
			_mapper.storeMapping(newUUID, oxObjectId);
			fail("OXObjectAlreadyMappedException not thrown!");
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		} catch (OXObjectAlreadyMappedException e) {
			//should be thrown
		} catch (UUIDAlreadyMappedException e) {
			fail(e.getMessage());
		}

		cid = _contextId;
		objectId = 200;
		contentType = 4;
		oxObjectId = new OXObjectID(cid, contentType, objectId);

		try {
			_mapper.storeMapping(uuid, oxObjectId);
			fail("UUIDAlreadyMappedException not thrown!");
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		} catch (OXObjectAlreadyMappedException e) {
			fail(e.getMessage());
		} catch (UUIDAlreadyMappedException e) {
			//should be thrown
		}

	}

	public void testGetMappedObject() {
		int cid = _contextId;
		int objectId = 100;
		int contentType = 5;

		OXObjectID oxObjId = new OXObjectID(cid, contentType, objectId);
		try {
			UUID uuid = _mapper.getUUID(cid, contentType, objectId);
			if (uuid == null)
				fail("No uuid generated");
			OXObjectID savedOXObjId = _mapper.getMappedObject(cid, uuid);
			assertTrue(oxObjId.equals(savedOXObjId));
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}
	}

	@Override
	protected void tearDown() throws Exception {
		Statement statement = _con.createStatement();
		try {
			statement.executeUpdate("drop index UUIDMappingUIDX");
			statement.executeUpdate("drop table UUIDMapping");
		} finally {
			statement.close();
			_con.close();
		}
	}

}
