/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.test;

import junit.framework.TestCase;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.session.dataobject.SimpleDataObject;
import com.openexchange.usm.syncml.mapping.MappingFailedException;
import com.openexchange.usm.syncml.mapping.vcard.VCard_2_1_Mapping;

public class VCard_2_1_MappingTest extends TestCase {

	Session _session = new SimSession();
	ContentType _type = new SimContactContentType();
	VCard_2_1_Mapping _mapping = new VCard_2_1_Mapping();

	protected void setUp() throws Exception {

	}

	public void test1() throws MappingFailedException {
		DataObject obj = new SimpleDataObject(_session, _type);
		StringBuilder vcardSb = new StringBuilder();
		vcardSb.append("BEGIN:VCARD");
		vcardSb.append("\n");
		vcardSb.append("VERSION:2.1");
		vcardSb.append("\n");
		vcardSb.append("N:Mustermann;Max");
		vcardSb.append("\n");
		vcardSb.append("FN:Max Mustermann");
		vcardSb.append("\n");
		vcardSb.append("ORG:Wikipedia");
		vcardSb.append("\n");
		vcardSb.append("URL:http://de.wikipedia.org/");
		vcardSb.append("\n");
		vcardSb.append("EMAIL;TYPE=INTERNET:max.mustermann@example.org");
		vcardSb.append("\n");
		vcardSb.append("TEL;TYPE=voice,work,pref:+49 1234 56788");
		vcardSb.append("\n");
		vcardSb.append("ADR;TYPE=intl,work,postal,parcel:Musterstrasse 1;Musterstadt;;12345;Germany");
		vcardSb.append("\n");
		vcardSb.append("END:VCARD");
		String vcard = vcardSb.toString();

		_mapping.mapToDataObject(vcard, obj);
		assertEquals(vcard, _mapping.mapToText(obj));
	}

	public void test2() throws MappingFailedException {
		DataObject obj = new SimpleDataObject(_session, _type);
		StringBuilder vcardSb = new StringBuilder();
		vcardSb.append("BEGIN:VCARD");
		vcardSb.append("\n");
		vcardSb.append("VERSION:2.1");
		vcardSb.append("\n");
		vcardSb.append("N:Mustermann;Max");
		vcardSb.append("\n");
		vcardSb.append("FN:Max \"Mustermann");
		vcardSb.append("\n");
		vcardSb.append("ORG:Wikipedia");
		vcardSb.append("\n");
		vcardSb.append("URL:http://de.wikipedia.org/");
		vcardSb.append("\n");
		vcardSb.append("EMAIL;TYPE=INTERNET:max.mustermann@example.org");
		vcardSb.append("\n");
		vcardSb.append("TEL;HOME;VOICE:+49 1234 56788");
		vcardSb.append("\n");
		vcardSb.append("TEL;CELL:+49 1234 56789");
		vcardSb.append("\n");
		vcardSb.append("TEL;HOME;FAX:+49 1234 12345");
		vcardSb.append("\n");
		vcardSb.append("ADR;HOME:Musterstrasse 1;Musterstadt;;12345;Deutschland");
		vcardSb.append("\n");
		vcardSb.append("END:VCARD");
		String vcard = vcardSb.toString();
		_mapping.mapToDataObject(vcard, obj);
		assertEquals(vcard, _mapping.mapToText(obj));
	}
	
	
	public void test3() throws MappingFailedException {
		DataObject obj = new SimpleDataObject(_session, _type);
		obj.setFieldContent("telephone_home1", "12345");
		StringBuilder vcardSb = new StringBuilder();
		vcardSb.append("BEGIN:VCARD");
		vcardSb.append("\n");
		vcardSb.append("VERSION:2.1");
		vcardSb.append("\n");
		vcardSb.append("N:Flick;Hansi;;;");
		vcardSb.append("\n");
		vcardSb.append("FN:Flick, Hansi");
		vcardSb.append("\n");
		vcardSb.append("ORG:;");
		vcardSb.append("\n");
		vcardSb.append("URL:");
		vcardSb.append("\n");
		vcardSb.append("EMAIL:");
		vcardSb.append("\n");
		vcardSb.append("TEL;HOME;VOICE;X-Synthesis-Ref1:");
		vcardSb.append("\n");
		vcardSb.append("BDAY:");
		vcardSb.append("\n");
		vcardSb.append("ADR;HOME:;;;;;;");
		vcardSb.append("\n");
		vcardSb.append("END:VCARD");
		String vcard = vcardSb.toString();
		_mapping.mapToDataObject(vcard, obj);
		assertEquals(vcard, _mapping.mapToText(obj));
	}

}
