/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.test;

import java.io.*;
import java.util.Arrays;

import junit.framework.TestCase;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;

import com.openexchange.usm.syncml.SyncMLConstants;

/**
 * 
 * @author ibr
 *
 */
public class SyncMLTestCase extends TestCase {
	private static final boolean WBXML = false;

	private static final String APPLICATION_VND_SYNCML = "application/vnd.syncml-xml; charset=\"utf-8\"";
	private static final String CONTENT_TYPE = "Content-Type";

	public final static String TESTS_BASEDIR = "../com.openexchange.usm.syncml/testfiles";
	private static final String USM_BASE_URL = "http://ox-p5.microdoc.dmz:80/usm-syncml";

	//	private static final String USM_BASE_URL = "http://localhost:8080/usm-syncml";

	private static String getMainName(File inFile) {
		String name = inFile.getName();
		return name.endsWith("_IN.test") ? name.substring(0, name.indexOf("_IN.test")) : name;
	}

	private final HttpClient _httpclient = new HttpClient();
	private final String _inFileName;
	private final File _inFile;
	private final File _baseDir;
	private final String _outFileName;
	private File _outFile;

	public SyncMLTestCase(File inFile, File baseDir) {
		super(getMainName(inFile));
		_inFileName = inFile.getName();
		_inFile = inFile;
		_baseDir = baseDir;
		_outFileName = _inFileName.substring(0, _inFileName.indexOf("_IN.test")) + "_OUT.test";
	}

	@Override
	protected void setUp() {
	}

	@Override
	protected void runTest() throws Throwable {
		assertTrue("Coresponding output file for input file: " + _inFileName + " doesn't exist",
				outFileExists(_baseDir));
		byte[] serverResponse = performCall();
		byte[] expectedResponse = readExpectedResponse();
		if (WBXML) {
			assertEquals("Return data does not match", Arrays.toString(expectedResponse), Arrays
					.toString(serverResponse));
		} else {
			assertEquals(new String(expectedResponse, SyncMLConstants.UTF_8), new String(serverResponse,
					SyncMLConstants.UTF_8));
		}
	}

	private byte[] readExpectedResponse() throws IOException {
		FileInputStream input = new FileInputStream(_outFile);
		ByteArrayOutputStream output = new ByteArrayOutputStream();
		int b = input.read();
		while (b > -1) {
			output.write(b);
			b = input.read();
		}
		output.flush();
		return output.toByteArray();
	}

	@Override
	protected void tearDown() throws Exception {
	}

	private boolean outFileExists(File dir) {
		for (File file : dir.listFiles()) {
			if (file.isDirectory()) {
				boolean exists = outFileExists(file);
				if (exists)
					return true;
			} else {
				String fileName = file.getName();
				if (fileName.equals(_outFileName)) {
					_outFile = file;
					return true;
				}
			}
		}
		return false;
	}

	private boolean matchResponseWithOuputFile(byte[] response) {
		try {
			FileInputStream input = new FileInputStream(_outFile);
			ByteArrayOutputStream output = new ByteArrayOutputStream();
			int b = input.read();
			while (b > -1) {
				output.write(b);
				b = input.read();
			}
			output.flush();
			return Arrays.equals(response, output.toByteArray());
		} catch (FileNotFoundException e) {
			System.out.println("Error on reading the out file");
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			System.out.println("Error on reading the out file");
			e.printStackTrace();
			return false;
		}
	}

	private byte[] performCall() throws HttpException, IOException {
		PostMethod httppost = new PostMethod(USM_BASE_URL);
		FileInputStream input = new FileInputStream(_inFile);
		InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(input);
		httppost.setRequestEntity(requestEntity);
		httppost.setRequestHeader(new Header(CONTENT_TYPE, APPLICATION_VND_SYNCML)); //TODO: change this to accept xml and wbxml
		System.out.println("executing request " + _inFileName + " at " + httppost.getURI());
		int statusCode = _httpclient.executeMethod(httppost);
		System.out.println("statusCode= " + statusCode);
		byte[] data = httppost.getResponseBody();
		System.out.println(new String(data));
		System.out.println("----------------------------------------");
		return data;
	}

}
