/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.test;

public class NokiaN95_Funambol_initial {

	public static final String[][] REQUESTS = {
			{
					"",
					"029f536a006d6c71c303312e310172c30a53796e634d4c2f312e310165c30133015bc30131016e57c32e687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f647301016757c314494d45493a33353839393830313035313533303501015a00014cc305313030303001000001016b464bc30131014fc30332303101546e57c3062e2f6361726401016757c3102e2f433a436f6e74616374732e63646201015a0001454ac300014fc3103230313030373038543133303633395a010100000101015f4bc30132015a000153c3236170706c69636174696f6e2f766e642e73796e636d6c2d646576696e662b7762786d6c01000001546757c30a2e2f646576696e66313101014fc38c10029f546a004a65c303312e310151c3054e4f4b49410155c3034e3935014fc300015ec30a562031322e302e3031330150c3000149c314494d45493a333538393938303130353135333035014bc30570686f6e6501282a29475dc3102e2f433a436f6e74616374732e636462014cc308436f6e74616374730152c30138015a46c30c746578742f782d76636172640164c303322e3101016246c30c746578742f782d76636172640164c303322e3101015f60c301310160c301320160c301330160c301340160c301350160c301360160c301370101014546c30c746578742f782d76636172640158c305424547494e0163c3055643415244014cc305426567696e0158c303454e440163c3055643415244014cc303456e640158c30756455253494f4e0163c303322e31014cc30756657273696f6e0158c3035245560148c300015cc303323536014cc3085265766973696f6e0158c3014e0148c300015cc303323536014cc3044e616d650158c3034144520148c300015cc303323536014cc307416464726573730157c304484f4d450148c300014cc30c486f6d6520616464726573730157c304574f524b0148c300014cc30c576f726b20616464726573730158c30354454c0148c300015cc303323536014cc31054656c6570686f6e65206e756d6265720157c304484f4d450148c300014cc30e486f6d652074656c6570686f6e650157c304574f524b0148c300014cc30e576f726b2074656c6570686f6e650157c30443454c4c0148c300014cc30f43656c6c756c6172206e756d6265720157c30550414745520148c300014cc30c5061676572206e756d6265720157c3034641580148c300014cc30a466178206e756d6265720157c305564944454f0148c300014cc30c566964656f206e756d6265720157c304505245460148c300014cc30e44656661756c74206e756d6265720157c3034341520148c300014cc30d4361722074656c6570686f6e650158c302464e0148c300015cc303323536014cc30846756c6c4e616d650158c305454d41494c0148c300015cc303323536014cc30d456d61696c20616464726573730157c304484f4d450148c300014cc30a486f6d6520656d61696c0157c304574f524b0148c300014cc30a576f726b20656d61696c0158c30355524c0148c300015cc303323536014cc30b55524c20616464726573730157c304484f4d450148c300014cc308486f6d652055524c0157c304574f524b0148c300014cc308576f726b2055524c0158c3044e4f54450148c300015cc303323536014cc3044e6f74650158c3055449544c450148c300015cc303323536014cc3055469746c650158c3034f52470148c300015cc303323536014cc30c4f7267616e69736174696f6e0158c30550484f544f0148c300015cc303323536014cc30550686f746f0158c304424441590148c300015cc303323536014cc30842697274686461790158c305534f554e440148c300015cc303323536014cc305536f756e640158c307582d57562d49440148c300015cc303323536014cc313576972656c6573732056696c6c6167652049640158c30b582d415353495354414e540148c300015cc303323536014cc30e417373697374616e74206e616d650158c30f582d415353495354414e542d54454c0148c300015cc303323536014cc30f417373697374616e742070686f6e650158c30d582d414e4e49564552534152590148c300015cc303323536014cc30b416e6e69766572736172790158c308582d53504f5553450148c300015cc303323536014cc30653706f7573650158c30a582d4348494c4452454e0148c300015cc303323536014cc3084368696c6472656e0158c310582d45504f435345434f4e444e414d450148c300015cc303323536014cc3084e69636b6e616d650158c307582d434c4153530163c3065055424c49430163c307505249564154450163c30c434f4e464944454e5449414c014cc305436c6173730158c305582d5349500148c300015cc303323536014cc30c5349502070726f746f636f6c0157c303504f430148c300014cc303504f430157c304535749530148c300014cc304535749530157c304564f49500148c300014cc30d566f696365206f766572204950010101010101534bc30133015a000153c3236170706c69636174696f6e2f766e642e73796e636d6c2d646576696e662b7762786d6c01000001546e57c30a2e2f646576696e66313101010101120101",
					"0200006a1d2d2f2f53594e434d4c2f2f4454442053796e634d4c20312e312f2f454e6d6c7103312e310001720353796e634d4c2f312e31000165033300015b033100016e5703494d45493a333538393938303130353135333035000101675703687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64730001016103687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d38363333434230414145413330393235334642343245443636323144463344360001016b694b033100015c033100014c033000014a0353796e6348647200016f03687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f647300016803494d45493a3335383939383031303531353330350001495a000147036236340001530373796e636d6c3a617574682d62617369630001010100004f03343037000101694b033200015c033100014c033100014a03416c65727400016f032e2f63617264000168032e2f433a436f6e74616374732e63646200014f03343037000101694b033300015c033100014c033200014a03507574000168032e2f646576696e66313100014f03343037000101694b033400015c033100014c033300014a0347657400016f032e2f646576696e66313100014f03343037000101120101" },
			{
					"",
					"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",
					"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" },
			{
					"",
					"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",
					"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" },
			{
					"",
					"029f536a006d6c71c303312e310172c30a53796e634d4c2f312e310165c30133015bc30134016e57c35a687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d383633334342304141454133303932353346423432454436363231444633443601016757c314494d45493a33353839393830313035313533303501015a00014cc305313030303001000001016b464bc30131014fc30332323201546e57c35a687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d383633334342304141454133303932353346423432454436363231444633443601016757c314494d45493a33353839393830313035313533303501010101694bc30132015cc30133014cc30130014ac30753796e63486472016fc314494d45493a3335383939383031303531353330350168c35a687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d3836333343423041414541333039323533464234324544363632314446334436014fc30332303001010101",
					"0200006a1d2d2f2f53594e434d4c2f2f4454442053796e634d4c20312e312f2f454e6d6c7103312e310001720353796e634d4c2f312e31000165033300015b033400016e5703494d45493a333538393938303130353135333035000101675703687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d38363333434230414145413330393235334642343245443636323144463344360001016103687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d38363333434230414145413330393235334642343245443636323144463344360001016b694b033100015c033400014c033000014a0353796e6348647200016f03687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d383633334342304141454133303932353346423432454436363231444633443600016803494d45493a33353839393830313035313533303500014f03323030000101694b033200015c033400014c033100014a03416c65727400016f03687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d383633334342304141454133303932353346423432454436363231444633443600016803494d45493a33353839393830313035313533303500014f033230300001546e5703687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d3836333343423041414541333039323533464234324544363632314446334436000101675703494d45493a33353839393830313035313533303500010101016a4b033300016e57032e2f433a436f6e74616374732e6364620001016757032e2f63617264000101730330000101120101" },
			{
					"",
					"029f536a006d6c71c303312e310172c30a53796e634d4c2f312e310165c30133015bc30135016e57c35a687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d383633334342304141454133303932353346423432454436363231444633443601016757c314494d45493a33353839393830313035313533303501015a00014cc305313030303001000001016b694bc30131015cc30134014cc30130014ac30753796e63486472016fc314494d45493a3335383939383031303531353330350168c35a687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d3836333343423041414541333039323533464234324544363632314446334436014fc3033230300101694bc30132015cc30134014cc30133014ac30453796e63016fc3102e2f433a436f6e74616374732e6364620168c3062e2f63617264014fc3033230300101120101",
					"0200006a1d2d2f2f53594e434d4c2f2f4454442053796e634d4c20312e312f2f454e6d6c7103312e310001720353796e634d4c2f312e31000165033300015b033500016e5703494d45493a333538393938303130353135333035000101675703687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d38363333434230414145413330393235334642343245443636323144463344360001016103687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d38363333434230414145413330393235334642343245443636323144463344360001016b694b033100015c033500014c033000014a0353796e6348647200016f03687474703a2f2f7562756e74752d70352e6d6963726f646f632e636f6d3a383038302f66756e616d626f6c2f64733b6a73657373696f6e69643d383633334342304141454133303932353346423432454436363231444633443600016803494d45493a33353839393830313035313533303500014f03323030000101120101" } };
}
