/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.util;

import java.io.ByteArrayOutputStream;

import org.xmlpull.v1.XmlSerializer;

import com.openexchange.usm.syncml.SyncMLConstants;
import com.openexchange.usm.syncml.elements.SyncMLElement;
import com.openexchange.usm.syncml.parser.XmlSerializerFactory;

public class XmlSizeSupport {

	/**
	 * Fixed increase to add to computed size to allow for small differences, e.g. due to composition of multiple elements
	 */
	private static final int CONSTANT_DELTA = 8;

	/**
	 * Increase in percent to computed size (100 == no modification), applied after the fixed increase is added
	 */
	private static final int PERCENTAGE_DELTA = 110;

	private static final int WBXML_COMMON_OVERHEAD = 34;

	private static final int XML_COMMON_OVERHEAD = 40;

	public static int computeSize(SyncMLElement element, boolean wbxml, boolean isMainElement) {
		XmlSerializer serializer = XmlSerializerFactory.getInstance().getSerializer(wbxml);
		ByteArrayOutputStream output = new ByteArrayOutputStream();
		try {
			serializer.setOutput(output, SyncMLConstants.UTF_8);
			if (!isMainElement)
				serializer.startDocument(SyncMLConstants.UTF_8, null);
			element.write(serializer, null);
			if (!isMainElement)
				serializer.endDocument();
			int size = output.size();
			if (!isMainElement)
				size -= wbxml ? WBXML_COMMON_OVERHEAD : XML_COMMON_OVERHEAD;
			return addSecurityMargin(size);
		} catch (Exception ignored) {
			// If an error occurred, return a very large value;
		}
		return 1000000;
	}

	private static int addSecurityMargin(int computedValue) {
		return ((computedValue + CONSTANT_DELTA) * PERCENTAGE_DELTA) / 100;
	}
}
