/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.servlet;

import java.io.*;

import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.kxml2.wap.*;
import org.xmlpull.v1.*;

import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.syncml.SyncMLConstants;
import com.openexchange.usm.syncml.parser.wbxml.SyncML;
import com.openexchange.usm.syncml.parser.wbxml.SyncMLDevInf;

public class WbxmlTransformer {

	public byte[] transformXmlToWbxml(String xml) throws XmlPullParserException, IOException, USMException {
		return transformXmlToWbxml(new WbxmlSerializer(), xml);
	}

	public byte[] transformXmlToWbxml(XmlSerializer serializer, String xml) throws XmlPullParserException, IOException,
			USMException {
		XmlPullParser parser = new KXmlParser();
		parser.setInput(new StringReader(xml));
		ByteArrayOutputStream output = new ByteArrayOutputStream();
		serializer.setOutput(output, SyncMLConstants.UTF_8);
		transform(parser, serializer);
		return output.toByteArray();
	}

	public String formatXml(String xml) throws XmlPullParserException, IOException {
		XmlPullParser parser = new KXmlParser();
		parser.setInput(new StringReader(xml));
		KXmlSerializer serializerXml = new KXmlSerializer();
		StringWriter xmlAsStringWriter = new StringWriter();
		serializerXml.setOutput(xmlAsStringWriter);
		transform(parser, serializerXml, true, 0);
		xmlAsStringWriter.flush();
		xmlAsStringWriter.close();
		return xmlAsStringWriter.getBuffer().toString();
	}

	public String transformSyncMLWbxmlToXml(byte[] inputByteArray) throws XmlPullParserException, USMException,
			IOException {
		return transformWbxmlToXml(SyncML.createParser(), inputByteArray);
	}

	public String transformSyncMLDevInfWbxmlToXml(byte[] inputByteArray) throws XmlPullParserException, USMException,
			IOException {
		return transformWbxmlToXml(SyncMLDevInf.createParser(), inputByteArray);
	}

	public String transformWbxmlToXml(byte[] inputByteArray) throws XmlPullParserException, USMException, IOException {
		return transformWbxmlToXml(new WbxmlParser(), inputByteArray);
	}

	public String transformWbxmlToXml(WbxmlParser parser, byte[] inputByteArray) throws XmlPullParserException,
			USMException, IOException {
		return transformWbxmlToXml(parser, inputByteArray, true, 0);
	}

	public String transformWbxmlToXml(WbxmlParser parser, byte[] inputByteArray, boolean formatted, int index)
			throws XmlPullParserException, USMException, IOException {
		//WBXML -->XML
		ByteArrayInputStream input = new ByteArrayInputStream(inputByteArray);
		parser.setInput(input, SyncMLConstants.UTF_8);
		KXmlSerializer serializerXml = new KXmlSerializer();
		StringWriter xmlAsStringWriter = new StringWriter();
		serializerXml.setOutput(xmlAsStringWriter);
		transform(parser, serializerXml, formatted, index);
		xmlAsStringWriter.flush();
		xmlAsStringWriter.close();
		return xmlAsStringWriter.getBuffer().toString();
	}

	private void transform(XmlPullParser parser, XmlSerializer serializer) throws XmlPullParserException, IOException {
		transform(parser, serializer, false, 0);
	}

	private void transform(XmlPullParser parser, XmlSerializer serializer, boolean formatted, int indent)
			throws XmlPullParserException, IOException {
		int eventType = parser.getEventType();
		boolean hadStartTag = true;
		boolean hadEndTag = false;
		StringBuilder sb = new StringBuilder(2 * indent);
		for (int i = 0; i < indent; i++)
			sb.append("  ");
		serializer.text(sb.toString());
		indent--;
		while (eventType != XmlPullParser.END_DOCUMENT) {
			if (eventType == XmlPullParser.START_DOCUMENT) {
				serializer.startDocument(SyncMLConstants.UTF_8, null);
			} else if (eventType == XmlPullParser.END_DOCUMENT) {
				serializer.endDocument();
			} else if (eventType == XmlPullParser.START_TAG) {
				indent++;
				if ((hadStartTag || hadEndTag) && formatted) {
					printNewline(serializer, indent);
				}
				serializer.startTag(null, parser.getName());
				hadStartTag = true;
				hadEndTag = false;
			} else if (eventType == XmlPullParser.END_TAG) {
				//				if (parser instanceof WbxmlParser) {
				//					WbxmlParser p2 = (WbxmlParser) parser;
				//					if (hadStartTag && p2.getWapCode() == Wbxml.OPAQUE) {
				//						Object o = p2.getWapExtensionData();
				//						if (o instanceof byte[]) {
				//							serializer.text(new String((byte[]) o, "UTF-8"));
				//							hadEndTag = false;
				//						}
				//					}
				//				}
				if (hadEndTag && formatted) {
					printNewline(serializer, indent);
				}
				serializer.endTag(null, parser.getName());
				hadEndTag = true;
				hadStartTag = false;
				indent--;
			} else if (eventType == XmlPullParser.TEXT) {
				String text = parser.getText();
				if (text.trim().length() > 0 || !parser.isWhitespace()) {
					serializer.text(text);
					hadEndTag = false;
				}
			} else if (eventType == Wbxml.EXT_I_0) {
				WbxmlParser p2 = (WbxmlParser) parser;
				if (p2.getWapCode() == Wbxml.OPAQUE) {
					Object o = p2.getWapExtensionData();
					if (o instanceof byte[]) {
						byte[] ba = (byte[]) o;
						if (ba.length > 80) {
							try {
								String s = transformSyncMLDevInfWbxmlToXml(ba);
								serializer.text(s);
							} catch (Exception e) {
								serializer.text(new String(ba, "UTF-8"));
							}
						} else {
							serializer.text(new String(ba, "UTF-8"));
						}
						hadEndTag = false;
					}
				}
			} else if (eventType != XmlPullParser.IGNORABLE_WHITESPACE) {
				System.err.println("Encountered event type " + eventType);
			}
			eventType = parser.nextToken();
		}
		if (eventType == XmlPullParser.END_DOCUMENT)
			serializer.endDocument();
	}

	private void printNewline(XmlSerializer serializer, int indent) throws IOException {
		StringBuilder sb = new StringBuilder("\n");
		for (int i = 0; i < indent; i++)
			sb.append("  ");
		serializer.text(sb.toString());
	}

}
