/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.servlet;

import java.util.BitSet;
import java.util.List;

import org.json.JSONObject;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.contenttypes.DefaultContentTypes;
import com.openexchange.usm.api.exceptions.*;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.api.session.SessionInitializer;
import com.openexchange.usm.syncml.SyncMLBundleErrorCodes;
import com.openexchange.usm.syncml.mapping.ContentTypeMapping;
import com.openexchange.usm.syncml.mapping.ContentTypeMappings;
import com.openexchange.usm.util.JSONToolkit;

public class SyncMLSessionInitializer implements SessionInitializer {

	private final SyncMLServlet _servlet;

	public SyncMLSessionInitializer(SyncMLServlet syncMLServlet) {
		_servlet = syncMLServlet;
	}

	public void initializeSession(Session session, JSONObject ajaxConfiguration) throws USMException {
		reinitializeSession(session, ajaxConfiguration); //called to set the custom properties
		setContentTypeFilters(session);
		// TODO Other initializations for the USM session ?
	}

	public void reinitializeSession(Session session, JSONObject ajaxConfiguration) throws USMException {
		checkAccess(session, ajaxConfiguration);
		// TODO Remove this once we have all default fields for synchronization finished
		//		setContentTypeFilters(session);
		// TODO Other re-initializations for the USM session ?
	}

	public void checkAccess(Session session) throws USMException {
		checkAccess(session, null);
	}

	private void checkAccess(Session session, JSONObject ajaxConfiguration) throws USMAccessDeniedException,
			AuthenticationFailedException, OXCommunicationException {
		JSONObject oxInterfaces = getUSMJSONModule(session, ajaxConfiguration);
		if (oxInterfaces == null || !oxInterfaces.optBoolean("module")) {
			throw new USMAccessDeniedException(SyncMLBundleErrorCodes.INITIALIZER_USM_SYNCML_ACCESS_DENIED_FOR_USER,
					"USM JSON access disabled for user");
		}
	}

	private JSONObject getUSMJSONModule(Session session, JSONObject ajaxConfiguration)
			throws AuthenticationFailedException, OXCommunicationException {
		if (ajaxConfiguration != null)
			return JSONToolkit.getJSONObject(ajaxConfiguration, "modules", "com.openexchange.usm.syncml");
		try {
			return session.getOXUserConfiguration("modules", "com.openexchange.usm.syncml");
		} catch (OXCommunicationException e) {
			return null;
		}
	}

	private void setContentTypeFilters(Session session) throws USMException {
		setContentTypeFilter(session, DefaultContentTypes.FOLDER_ID, "id", "folder_id", "title", "permissions",
				"module", "subfolders", "type", "own_rights", "standard_folder", "standard_folder_type" /* TODO If any other field is missing, add here */);
		// By default, we want to synchronize all fields supported by all mappings for each ContentType
		for (ContentType type : _servlet.getContentTypeManager().getRegisteredContentTypes()) {
			if (!DefaultContentTypes.FOLDER_ID.equals(type.getID())) {
				BitSet filter = new BitSet();
				List<ContentTypeMapping> mappings = ContentTypeMappings.getMappings(type);
				if (mappings != null) {
					for (ContentTypeMapping mapping : mappings)
						filter.or(mapping.getSynchronizationFields(type));
				}
				session.setFieldFilter(type, filter);
			}
		}
		// LATER Maybe we should determine the default list from the capabilities of all currently installed mappings ?
		//		setContentTypeFilter(session, DefaultContentTypes.CONTACTS_ID, "id", "folder_id", // OX identity
		//				"display_name", // == FN
		//				"first_name", "last_name", "second_name", "title", "suffix", // == N
		//				"email1", "email2", "email3", // == MAIL (how do we map multiple occurrences ?)
		//				"company", "department", // == ORG (how do we handle multiple department hierarchies ?)
		//				"street_home", "postal_code_home", "city_home", "state_home", "country_home", // == ADR(type=home:po box, ext. addr, street, city, region, postal code, country)
		//				"street_business", "postal_code_business", "city_business", "state_business", "country_business", // == ADR(type=work:po box, ext. addr, street, city, region, postal code, country)
		//				"cellular_telephone1", // == TEL(type=home,cell) (correct?)
		//				"cellular_telephone2", // == TEL(type=work,cell) (correct?)
		//				"telephone_home1", // == TEL(type=home)
		//				"telephone_business1", // == TEL(type=work)
		//				"url", // == URL
		//				"birthday" // == BDAY
		//		);
	}

	private void setContentTypeFilter(Session session, String type, String... fields) throws USMException {
		ContentType contentType = _servlet.getContentTypeManager().getContentType(type);
		if (contentType == null)
			throw new InternalUSMException(SyncMLBundleErrorCodes.REQUIRED_CONTENTTYPE_NOT_AVAILABLE,
					"Required ContentType " + type + " not available");
		session.setFieldFilter(contentType, fields);
	}
}
