package com.openexchange.usm.syncml.servlet;

public class HexDumper {
	private final static String HEX_DIGITS = "0123456789ABCDEF";

	public static String toString(byte[] byteArray) {
		StringBuilder sb = new StringBuilder(byteArray.length + 3);
		for (int i = 0; i < byteArray.length; i += 20) {
			StringBuilder sb2 = new StringBuilder(20);
			for (int j = 0; j < 20; j++) {
				if (i + j >= byteArray.length) {
					sb.append("   ");
					sb2.append(' ');
				} else {
					int b = ((int) byteArray[i + j]) & 0xFF;
					sb.append(HEX_DIGITS.charAt(b / 16)).append(HEX_DIGITS.charAt(b % 16)).append(' ');
					if ((b >= 32 && b <= 127) || (b >= 160))
						sb2.append((char) b);
					else
						sb2.append('.');
				}
			}
			sb.append(sb2.toString()).append('\n');
		}
		return sb.toString();
	}

	public static String toShortString(byte[] byteArray) {
		StringBuilder sb = new StringBuilder(byteArray.length*2);
		for (int i = 0; i < byteArray.length; i++) {
			int b = ((int) byteArray[i]) & 0xFF;
			sb.append(HEX_DIGITS.charAt(b / 16)).append(HEX_DIGITS.charAt(b % 16));
		}
		return sb.toString();
	}
}
