package com.openexchange.usm.syncml.servlet;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Special DebugWriter that writes into a common EAS debug log file (not the normal logging mechanism)
 * 
 * @author afe
 *
 */
public class DebugPrintWriter extends PrintWriter implements DebugWriter {
	private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

	public DebugPrintWriter(String fileName) throws FileNotFoundException {
		super(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName, true))), false);
		log("EAS Servlet debug logging started");
		flush();
	}

	public void log(String x) {
		String logEntry;
		synchronized (DATE_FORMAT) {
			logEntry = DATE_FORMAT.format(new Date()) + ": " + x;
		}
		println(logEntry);
	}

	@Override
	public void close() {
		log("EAS Servlet debug logging stopped");
		super.close();
	}
}
