package com.openexchange.usm.syncml.servlet;

import java.io.IOException;

import org.apache.commons.logging.Log;

/**
 * Special DebugWriter that writes into the standard logging system
 * 
 * @author afe
 *
 */
public class DebugLogWriter implements DebugWriter {
	private final String _descriptor;

	private final Log _journal;

	public DebugLogWriter(Log journal, String descriptor) {
		_descriptor = descriptor;
		_journal = journal;
	}

	public void flush() {
		// Nothing to do
	}

	public void log(String x) {
		_journal.info(_descriptor + ' ' + x);
	}

	public void close() throws IOException {
		// Nothing to do
	}
}
