/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
/* Copyright (c) 2002,2003, Stefan Haustein, Oberhausen, Rhld., Germany
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The  above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE. */

//Contributors: Jonathan Cox, Bogdan Onoiu, Jerry Tian
package com.openexchange.usm.syncml.parser.wbxml;

/*
 * Modified for ease of use (no empty namespace checking), and adjusted for Java 5.
 * Original code in package org.kxml2.wap.WbxmlSerializer
 */

import java.io.*;
import java.util.*;

import org.kxml2.wap.Wbxml;
import org.xmlpull.v1.XmlSerializer;

// TODO: make some of the "direct" WBXML token writing methods public??

/**
 * A class for writing WBXML.
 *
 */

public class WbxmlSerializer implements XmlSerializer {
	//	private static final int WBXML_VERSION = 0x03; // version 1.3
	private static final int WBXML_VERSION = 0x02; // version 1.2
	private final static boolean CHECK_NAMESPACE_USAGE = false;
	private final static boolean USE_SYNCML_IDENTIFIER = true;

	protected String getGlobalNamespace() {
		return "-//SYNCML//DTD SyncML 1.1//EN";
	}

	protected boolean isStrTDisabled() {
		return true;
	}

	private final Map<String, Integer> stringTable = new HashMap<String, Integer>();

	OutputStream out;

	private ByteArrayOutputStream buf = new ByteArrayOutputStream();
	private ByteArrayOutputStream stringTableBuf = new ByteArrayOutputStream();

	String pending;
	int depth;
	String name;
	String namespace;

	private final List<String> attributes = new ArrayList<String>();

	private final Map<String, int[]> attrStartTable = new HashMap<String, int[]>();
	private final Map<String, int[]> attrValueTable = new HashMap<String, int[]>();
	private final Map<String, int[]> tagTable = new HashMap<String, int[]>();

	private int attrPage;
	private int tagPage;

	private String encoding;

	public XmlSerializer attribute(String namespace, String name, String value) {
		attributes.add(name);
		attributes.add(value);
		return this;
	}

	public void cdsect(String cdsect) throws IOException {
		text(cdsect);
	}

	/* silently ignore comment */

	public void comment(String comment) {
	}

	public void docdecl(String docdecl) {
		throw new RuntimeException("Cannot write docdecl for WBXML");
	}

	public void entityRef(String er) {
		throw new RuntimeException("EntityReference not supported for WBXML");
	}

	public int getDepth() {
		return depth;
	}

	public boolean getFeature(String name) {
		return false;
	}

	public String getNamespace() {
		throw new RuntimeException("NYI");
	}

	public String getName() {
		throw new RuntimeException("NYI");
	}

	public String getPrefix(String nsp, boolean create) {
		throw new RuntimeException("NYI");
	}

	public Object getProperty(String name) {
		return null;
	}

	public void ignorableWhitespace(String sp) {
	}

	public void endDocument() throws IOException {
		writeInt(out, stringTableBuf.size());

		// write StringTable

		out.write(stringTableBuf.toByteArray());

		// write buf

		out.write(buf.toByteArray());

		// ready!

		out.flush();
	}

	/** ATTENTION: flush cannot work since Wbxml documents require
	  buffering. Thus, this call does nothing. */

	public void flush() {
	}

	public void checkPending(boolean degenerated) throws IOException {
		if (pending == null)
			return;

		int len = attributes.size();

		int[] idx = tagTable.get(pending);

		// if no entry in known table, then add as literal
		if (idx == null) {
			buf.write(len == 0 ? (degenerated ? Wbxml.LITERAL : Wbxml.LITERAL_C) : (degenerated ? Wbxml.LITERAL_A
					: Wbxml.LITERAL_AC));

			writeStrT(pending, false);
		} else {
			if (idx[0] != tagPage) {
				tagPage = idx[0];
				buf.write(Wbxml.SWITCH_PAGE);
				buf.write(tagPage);
			}

			buf.write(len == 0 ? (degenerated ? idx[1] : idx[1] | 64) : (degenerated ? idx[1] | 128 : idx[1] | 192));

		}

		for (int i = 0; i < len;) {
			idx = attrStartTable.get(attributes.get(i));

			if (idx == null) {
				buf.write(Wbxml.LITERAL);
				writeStrT(attributes.get(i), false);
			} else {
				if (idx[0] != attrPage) {
					attrPage = idx[0];
					buf.write(0);
					buf.write(attrPage);
				}
				buf.write(idx[1]);
			}
			idx = attrValueTable.get(attributes.get(++i));
			if (idx == null) {
				writeStr(attributes.get(i));
			} else {
				if (idx[0] != attrPage) {
					attrPage = idx[0];
					buf.write(0);
					buf.write(attrPage);
				}
				buf.write(idx[1]);
			}
			++i;
		}

		if (len > 0)
			buf.write(Wbxml.END);

		pending = null;
		attributes.clear();
	}

	public void processingInstruction(String pi) {
		throw new RuntimeException("PI NYI");
	}

	public void setFeature(String name, boolean value) {
		throw new IllegalArgumentException("unknown feature " + name);
	}

	public void setOutput(Writer writer) {
		throw new RuntimeException("Wbxml requires an OutputStream!");
	}

	public void setOutput(OutputStream out, String encoding) throws IOException {

		this.encoding = encoding == null ? "UTF-8" : encoding;
		this.out = out;

		buf = new ByteArrayOutputStream();
		stringTableBuf = new ByteArrayOutputStream();

		// ok, write header
	}

	public void setPrefix(String prefix, String nsp) {
		throw new RuntimeException("NYI");
	}

	public void setProperty(String property, Object value) {
		throw new IllegalArgumentException("unknown property " + property);
	}

	public void startDocument(String s, Boolean b) throws IOException {
		out.write(WBXML_VERSION);
		// http://www.openmobilealliance.org/tech/omna/omna-wbxml-public-docid.htm
		if (USE_SYNCML_IDENTIFIER) {
			out.write(0x00);
			writeStrT(getGlobalNamespace(), false, out);
		} else {
			out.write(0x01); // unknown or missing public identifier
		}

		// default encoding is UTF-8

		if (s != null) {
			encoding = s;
		}

		if (encoding.toUpperCase().equals("UTF-8")) {
			out.write(106);
		} else if (encoding.toUpperCase().equals("ISO-8859-1")) {
			out.write(0x04);
		} else {
			throw new UnsupportedEncodingException(s);
		}
	}

	public XmlSerializer startTag(String namespace, String name) throws IOException {

		if (CHECK_NAMESPACE_USAGE && namespace != null && !"".equals(namespace))
			throw new RuntimeException("NSP NYI");

		//current = new State(current, prefixMap, name);

		checkPending(false);
		pending = name;
		depth++;

		return this;
	}

	public XmlSerializer text(char[] chars, int start, int len) throws IOException {

		checkPending(false);

		writeStr(new String(chars, start, len));

		return this;
	}

	public XmlSerializer text(String text) throws IOException {

		checkPending(false);

		writeStr(text);

		return this;
	}

	/** Used in text() and attribute() to write text */

	private void writeStr(String text) throws IOException {
		if (isStrTDisabled()) {
			buf.write(Wbxml.STR_I);
			writeStrI(buf, text);
			return;
		}
		int p0 = 0;
		int lastCut = 0;
		int len = text.length();

		while (p0 < len) {
			while (p0 < len && text.charAt(p0) < 'A') { // skip interpunctation
				p0++;
			}
			int p1 = p0;
			while (p1 < len && text.charAt(p1) >= 'A') {
				p1++;
			}

			if (p1 - p0 > 10) {

				if (p0 > lastCut && text.charAt(p0 - 1) == ' ' && stringTable.get(text.substring(p0, p1)) == null) {

					buf.write(Wbxml.STR_T);
					writeStrT(text.substring(lastCut, p1), false);
				} else {

					if (p0 > lastCut && text.charAt(p0 - 1) == ' ') {
						p0--;
					}

					if (p0 > lastCut) {
						buf.write(Wbxml.STR_T);
						writeStrT(text.substring(lastCut, p0), false);
					}
					buf.write(Wbxml.STR_T);
					writeStrT(text.substring(p0, p1), true);
				}
				lastCut = p1;
			}
			p0 = p1;
		}

		if (lastCut < len) {
			buf.write(Wbxml.STR_T);
			writeStrT(text.substring(lastCut, len), false);
		}
	}

	public XmlSerializer endTag(String namespace, String name) throws IOException {

		//        current = current.prev;

		if (pending != null)
			checkPending(true);
		else
			buf.write(Wbxml.END);

		depth--;

		return this;
	}

	/** 
	 * @throws IOException */

	public void writeWapExtension(int type, Object data) throws IOException {
		checkPending(false);
		buf.write(type);
		switch (type) {
			case Wbxml.EXT_0:
			case Wbxml.EXT_1:
			case Wbxml.EXT_2:
				break;

			case Wbxml.OPAQUE:
				byte[] bytes = (byte[]) data;
				writeInt(buf, bytes.length);
				buf.write(bytes);
				break;

			case Wbxml.EXT_I_0:
			case Wbxml.EXT_I_1:
			case Wbxml.EXT_I_2:
				writeStrI(buf, (String) data);
				break;

			case Wbxml.EXT_T_0:
			case Wbxml.EXT_T_1:
			case Wbxml.EXT_T_2:
				writeStrT((String) data, false);
				break;

			default:
				throw new IllegalArgumentException();
		}
	}

	// ------------- internal methods --------------------------

	static void writeInt(OutputStream out, int i) throws IOException {
		byte[] buf = new byte[5];
		int idx = 0;

		do {
			buf[idx++] = (byte) (i & 0x7f);
			i = i >> 7;
		} while (i != 0);

		while (idx > 1) {
			out.write(buf[--idx] | 0x80);
		}
		out.write(buf[0]);
	}

	void writeStrI(OutputStream out, String s) throws IOException {
		byte[] data = s.getBytes(encoding);
		out.write(data);
		out.write(0);
	}

	private final void writeStrT(String s, boolean mayPrependSpace) throws IOException {
		writeStrT(s, mayPrependSpace, buf);
	}

	private final void writeStrT(String s, boolean mayPrependSpace, OutputStream buf) throws IOException {

		Integer idx = (Integer) stringTable.get(s);

		if (idx != null) {
			writeInt(buf, idx.intValue());
		} else {
			int i = stringTableBuf.size();
			if (s.charAt(0) >= '0' && mayPrependSpace) {
				s = ' ' + s;
				writeInt(buf, i + 1);
			} else {
				writeInt(buf, i);
			}

			stringTable.put(s, new Integer(i));
			if (s.charAt(0) == ' ') {
				stringTable.put(s.substring(1), new Integer(i + 1));
			}
			int j = s.lastIndexOf(' ');
			if (j > 1) {
				stringTable.put(s.substring(j), new Integer(i + j));
				stringTable.put(s.substring(j + 1), new Integer(i + j + 1));
			}

			writeStrI(stringTableBuf, s);
			stringTableBuf.flush();
		}

	}

	/**
	 * Sets the tag table for a given page.
	 * The first string in the array defines tag 5, the second tag 6 etc.
	 */

	public void setTagTable(int page, String[] tagTable) {
		// TODO: clear entries in tagTable?

		for (int i = 0; i < tagTable.length; i++) {
			if (tagTable[i] != null) {
				this.tagTable.put(tagTable[i], new int[] { page, i + 5 });
			}
		}
	}

	/**
	 * Sets the attribute start Table for a given page.
	 * The first string in the array defines attribute
	 * 5, the second attribute 6 etc.
	 *  Please use the
	 *  character '=' (without quote!) as delimiter
	 *  between the attribute name and the (start of the) value
	 */
	public void setAttrStartTable(int page, String[] attrStartTable) {
		for (int i = 0; i < attrStartTable.length; i++) {
			if (attrStartTable[i] != null) {
				this.attrStartTable.put(attrStartTable[i], new int[] { page, i + 5 });
			}
		}
	}

	/**
	 * Sets the attribute value Table for a given page.
	 * The first string in the array defines attribute value 0x85,
	 * the second attribute value 0x86 etc.
	 */
	public void setAttrValueTable(int page, String[] attrValueTable) {
		// clear entries in this.table!
		for (int i = 0; i < attrValueTable.length; i++) {
			if (attrValueTable[i] != null) {
				this.attrValueTable.put(attrValueTable[i], new int[] { page, i + 0x085 });
			}
		}
	}
}
