/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.parser.wbxml;

import org.kxml2.wap.WbxmlParser;

public abstract class SyncMLDevInf {

	// SyncML-DevInf (-//SYNCML//DTD DevInf 1.0//EN) support

	public static WbxmlParser createParser() {
		WbxmlParser p = new WbxmlParser();
		p.setTagTable(0, TAG_TABLE_0);
		return p;
	}

	public static WbxmlSerializer createSerializer() {
		WbxmlSerializerDevInfo s = new WbxmlSerializerDevInfo();
		s.setTagTable(0, TAG_TABLE_0);
		return s;
	}

	// Tables

	public static final String[] TAG_TABLE_0 = {

	//  -//SYNCML//DTD DevInf 1.0//EN

			"CTCap", // 0x05 
			"CTType", // 0x06 
			"DataStore", // 0x07 
			"DataType", // 0x08 
			"DevID", // 0x09 
			"DevInf", // 0x0a 
			"DevTyp", // 0x0b 
			"DisplayName", // 0x0c 
			"DSMem", // 0x0d 
			"Ext", // 0x0e 
			"FwV", // 0x0f 
			"HwV", // 0x10 
			"Man", // 0x11 
			"MaxGUIDSize", // 0x12 
			"MaxID", // 0x13 
			"MaxMem", // 0x14 
			"Mod", // 0x15 
			"OEM", // 0x16 
			"ParamName", // 0x17 
			"PropName", // 0x18 
			"Rx", // 0x19 
			"Rx-Pref", // 0x1a 
			"SharedMem", // 0x1b 
			"Size", // 0x1c 
			"SourceRef", // 0x1d 
			"SwV", // 0x1e 
			"SyncCap", // 0x1f 
			"SyncType", // 0x20 
			"Tx", // 0x21 
			"Tx-Pref", // 0x22 
			"ValEnum", // 0x23 
			"VerCT", // 0x24 
			"VerDTD", // 0x25 
			"Xnam", // 0x26 
			"Xval", // 0x27 
			"UTC", //0x28
			"SupportNumberOfChanges", //0x29
			"SupportLargeObjs", //0x2A
			"Unknown1",
			"Unknown2",
			"Unknown3",
			"Unknown4",
			"Unknown5",
			"Unknown6",
			"Unknown7",
			"Unknown8",
			"Unknown9",
			"Unknown10",
			"Unknown11",
			"Unknown12" };
}
