/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
/*
 * Copyright (C) 2009 MicroDoc GmbH, Munich, Germany
 */

package com.openexchange.usm.syncml.mapping.vcard;

import java.util.*;

import com.openexchange.usm.api.session.DataObject;

public abstract class FieldMapping {
	private static final String[] EMPTY_ARRAY = new String[0];

	protected final String _vCardProperty;
	protected final String[] _vCardOptions;
	protected final String[] _sendOptions;
	protected final String[] _oxFields;

	public FieldMapping(String prop, String[] options, String[] sendOptions, String... oxFields) {
		_vCardProperty = prop;
		_vCardOptions = (options == null) ? EMPTY_ARRAY : options;
		_sendOptions = (sendOptions == null) ? EMPTY_ARRAY : sendOptions;
		_oxFields = oxFields;
	}

	public boolean isFieldDefined(Map<String, String[]> properties) {
		String[] params = properties.get(_vCardProperty);
		if (params == null)
			return false;
		for (String p : _vCardOptions) {
			if (!hasParam(params, p))
				return false;
		}
		return true;
	}

	private boolean hasParam(String[] params, String p) {
		for (String s : params) {
			if (s.equalsIgnoreCase(p))
				return true;
		}
		return false;
	}

	public String getVCardProperty() {
		return _vCardProperty;
	}

	public String[] getVCardOptions() {
		return _vCardOptions;
	}

	public String[] getSendOptions() {
		return _sendOptions;
	}

	public String[] getOxFields() {
		return _oxFields;
	}

	/**
	 * Override this method for any special matching checks
	 * 
	 * @param entry
	 * @return
	 */
	public boolean matches(VCardEntry entry) {
		if (!_vCardProperty.equals(entry.getKey()))
			return false;
		for (String option : _vCardOptions) {
			if (entry.getOption(option) == null)
				return false;
		}
		return true;
	}

	protected void addToVCard(List<VCardEntry> vcard, List<String> data) {
		if (hasNonEmptyValues(data))
			vcard
					.add(new VCardEntry(_vCardProperty, _vCardOptions, _sendOptions, data.toArray(new String[data
							.size()])));
	}

	protected boolean hasNonEmptyValues(Collection<String> values) {
		for (String string : values) {
			if (string != null && string.trim().length() > 0)
				return true;
		}
		return false;
	}

	protected String buildStringData(Object dataObjectValue) {
		return dataObjectValue == null ? "" : String.valueOf(dataObjectValue);
	}

	public abstract Object storeInDataObject(VCardEntry entry, DataObject dataObject, Object object);

	public abstract void addToVCard(DataObject object, List<VCardEntry> vcard);
}
