/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.mapping;

import java.util.*;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.syncml.mapping.vcard.VCard_2_1_Mapping;

public class ContentTypeMappings {
	private final static List<ContentTypeMapping> ALL_MAPPINGS = new ArrayList<ContentTypeMapping>();
	private final static List<ContentTypeMapping> MAPPINGS_VIEW = Collections.unmodifiableList(ALL_MAPPINGS);
	private final static Map<String, List<ContentTypeMapping>> MAPPINGS_BY_CONTENT_TYPE = new HashMap<String, List<ContentTypeMapping>>();
	private final static Map<String, ContentTypeMapping> MAPPINGS_BY_MIME_TYPE = new HashMap<String, ContentTypeMapping>();

	static {
		addToMappings(new VCard_2_1_Mapping());
		// TODO Add all implemented mappings to global list, make sure that for each content type, the preferred mapping is added first
	}

	public static List<ContentTypeMapping> getAllMappings() {
		return MAPPINGS_VIEW;
	}

	private static void addToMappings(ContentTypeMapping mapping) {
		synchronized (ALL_MAPPINGS) {
			String contentType = mapping.getContentType();
			String mimeType = mapping.getMimeType();
			if (MAPPINGS_BY_MIME_TYPE.containsKey(mimeType))
				throw new IllegalStateException("Multiple mappings for mime type " + mimeType);
			// ALL_MAPPINGS
			ALL_MAPPINGS.add(mapping);

			// MAPPINGS_BY_CONTENT_TYPE
			List<ContentTypeMapping> list = MAPPINGS_BY_CONTENT_TYPE.get(contentType);
			if (list == null) {
				list = new ArrayList<ContentTypeMapping>();
				MAPPINGS_BY_CONTENT_TYPE.put(contentType, list);
			}
			list.add(mapping);

			// MAPPINGS_BY_MIME_TYPE
			MAPPINGS_BY_MIME_TYPE.put(mimeType, mapping);
		}
	}

	public static List<ContentTypeMapping> getMappings(ContentType type) {
		return (type == null) ? null : MAPPINGS_BY_CONTENT_TYPE.get(type.getID());
	}

	public static ContentTypeMapping getMapping(String type) {
		return MAPPINGS_BY_MIME_TYPE.get(type);
	}
}
