/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.elements;

import java.io.*;

import org.kxml2.wap.Wbxml;
import org.kxml2.wap.WbxmlParser;
import org.xmlpull.v1.*;

import com.openexchange.usm.syncml.SyncMLConstants;
import com.openexchange.usm.syncml.elements.xml.XMLPart;
import com.openexchange.usm.syncml.parser.XmlPullParserUtil;
import com.openexchange.usm.syncml.parser.wbxml.SyncMLDevInf;
import com.openexchange.usm.syncml.parser.wbxml.WbxmlSerializer;
import com.openexchange.usm.syncml.util.MimeTypeUtil;

public class Data extends BaseElement {
	public static final String ELEMENT_NAME = "Data";

	// Only 1 of those is actually in use
	private final String _stringContent;
	private final XMLPart _xmlContent;

	//	private boolean _writeAsOpaque = false;

	public Data(String content) {
		_stringContent = content;
		_xmlContent = null;
	}

	//	public Data(String content, boolean writeAsOpaque) {
	//		_stringContent = content;
	//		_xmlContent = null;
	//		_writeAsOpaque = writeAsOpaque;
	//	}

	public Data(XMLPart content) {
		_stringContent = null;
		_xmlContent = content;
	}

	public Data(XmlPullParser parser, Meta meta) throws XmlPullParserException, IOException {
		XmlPullParserUtil.skipWhitespace(parser);
		parser.require(XmlPullParser.START_TAG, null, ELEMENT_NAME);
		parser.nextToken();
		switch (parser.getEventType()) {
			case XmlPullParser.START_TAG: // Normal XML
				_stringContent = null;
				_xmlContent = XMLPart.readXMLPart(parser);
				break;
			case XmlPullParser.TEXT: // Normal String
				_stringContent = parser.getText();
				_xmlContent = null;
				parser.next();
				break;
			case Wbxml.EXT_I_0: // OPAQUE or something similar
				byte[] opaqueData = extractOpaqueData(parser);
				_xmlContent = extractXmlContent(opaqueData, meta);
				_stringContent = extractStringContent(opaqueData, _xmlContent);
				parser.next();
				break;
			default: // Anything else, can not be parsed
				_stringContent = "";
				_xmlContent = null;
				break;
		}
		XmlPullParserUtil.skipWhitespace(parser);
		readElementEnd(parser);
	}

	public String getElementName() {
		return ELEMENT_NAME;
	}

	@Override
	protected void writeContent(XmlSerializer serializer, Meta meta) throws IOException {
		throw new IllegalStateException("Normal write() not allowed for Data");
	}

	public boolean isStringContent() {
		return _stringContent != null;
	}

	public String getStringContent() {
		return _stringContent;
	}

	public XMLPart getXmlContent() {
		return _xmlContent;
	}

	@Override
	public void write(XmlSerializer serializer, Meta meta) throws IOException {
		serializer.startTag(SyncMLConstants.SYNCML_NS, getElementName());
		if (_xmlContent != null) {
			if (meta != null && MimeTypeUtil.isWbxmlEncoded(meta.getXMLData(SyncMLConstants.TYPE))
					&& (serializer instanceof WbxmlSerializer)) {
				WbxmlSerializer wbxmlSerializer = (WbxmlSerializer) serializer;
				ByteArrayOutputStream baos = new ByteArrayOutputStream();
				WbxmlSerializer subSerializer = SyncMLDevInf.createSerializer();
				subSerializer.setOutput(baos, SyncMLConstants.UTF_8);
				subSerializer.startDocument(SyncMLConstants.UTF_8, null);
				_xmlContent.write(subSerializer);
				subSerializer.endDocument();
				wbxmlSerializer.writeWapExtension(Wbxml.OPAQUE, baos.toByteArray());
			} else {
				_xmlContent.write(serializer);
			}
		} else {
			//			if(_writeAsOpaque) {
			//				WbxmlSerializer wbxmlSerializer = (WbxmlSerializer) serializer;
			//				wbxmlSerializer.writeWapExtension(Wbxml.OPAQUE, _stringContent.getBytes());
			//			}
			//			else 
			serializer.text(_stringContent);
		}
		serializer.endTag(SyncMLConstants.SYNCML_NS, getElementName());
	}

	private byte[] extractOpaqueData(XmlPullParser parser) {
		if (parser instanceof WbxmlParser) {
			WbxmlParser wbxmlParser = (WbxmlParser) parser;
			if (wbxmlParser.getWapCode() == Wbxml.OPAQUE) {
				Object o = wbxmlParser.getWapExtensionData();
				if (o instanceof byte[])
					return (byte[]) o;
			}
		}
		return null;
	}

	private XMLPart extractXmlContent(byte[] opaqueData, Meta meta) {
		if (opaqueData != null && (meta == null || MimeTypeUtil.isWbxmlEncoded(meta.getXMLData(SyncMLConstants.TYPE)))) {
			ByteArrayInputStream input = new ByteArrayInputStream(opaqueData);
			WbxmlParser parser = SyncMLDevInf.createParser();
			try {
				parser.setInput(input, SyncMLConstants.UTF_8);
				requireElement(parser, XmlPullParser.START_DOCUMENT);
				XMLPart result = XMLPart.readXMLPart(parser);
				requireElement(parser, XmlPullParser.END_DOCUMENT);
				return result;
			} catch (Exception ignored) {
				// TODO Remove this or change it to a logging of level info or less
				//				System.err.println("Error: " + ignored);
				//				ignored.printStackTrace(System.err);
				// If any exception occurs, we assume the opaque data is a String
			}
		}
		return null;
	}

	private String extractStringContent(byte[] opaqueData, XMLPart xmlContent) {
		if (xmlContent != null)
			return null;
		if (opaqueData != null) {
			try {
				return new String(opaqueData, SyncMLConstants.UTF_8);
			} catch (UnsupportedEncodingException e) {
			}
		}
		return "";
	}
}
