/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.elements;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import org.apache.commons.logging.Log;
import org.xmlpull.v1.*;

import com.openexchange.usm.api.exceptions.USMIllegalStateException;
import com.openexchange.usm.syncml.SyncMLBundleErrorCodes;
import com.openexchange.usm.syncml.SyncMLConstants;
import com.openexchange.usm.util.Toolkit;

public class Cred extends BaseElement {
	public static final String ELEMENT_NAME = "Cred";

	private final Meta _meta;
	private final Data _data;

	public Cred(Meta meta, Data data) {
		_meta = meta;
		_data = data;
	}

	public Cred(XmlPullParser parser, Meta meta) throws XmlPullParserException, IOException {
		readElementStart(parser);
		_meta = readOptionalMeta(parser, meta);
		_data = new Data(parser, _meta);
		readElementEnd(parser);
	}

	public String getElementName() {
		return ELEMENT_NAME;
	}

	@Override
	protected void writeContent(XmlSerializer serializer, Meta meta) throws IOException {
		if (_meta != null) {
			_meta.write(serializer, meta);
			meta = _meta;
		}
		_data.write(serializer, meta);
	}

	public Meta getMeta() {
		return _meta;
	}

	public Data getData() {
		return _data;
	}

	public String getBasicAuthentication(Log journal) {
		if (_meta != null) {
			String type = _meta.getXMLData(SyncMLConstants.TYPE);
			if (type != null && !SyncMLConstants.SYNCML_AUTH_BASIC.equals(type))
				return null;
			String format = _meta.getXMLData(SyncMLConstants.FORMAT);
			if (format != null && !SyncMLConstants.FORMAT_B64.equals(format))
				return null;
		}
		if (!_data.isStringContent())
			return null;
		try {
			return new String(Toolkit.decodeBase64(_data.getStringContent()), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new USMIllegalStateException(SyncMLBundleErrorCodes.UTF8_NOT_SUPPORTED, "UTF-8 not supported");
		} catch (Exception e) {
			journal.info("Client request with invalid data for base64 encoded authentication");
			return null;
		}
	}
}
