/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.elements;

import java.io.IOException;
import java.util.List;

import org.xmlpull.v1.*;

import com.openexchange.usm.syncml.SyncMLConstants;
import com.openexchange.usm.syncml.commands.SyncMLCommand;
import com.openexchange.usm.syncml.commands.SyncMLCommandFactory;
import com.openexchange.usm.syncml.parser.XmlPullParserUtil;

public abstract class BaseElement implements SyncMLElement {

	@Override
	public String toString() {
		return "<" + getElementName() + ">";
	}

	protected void readElementStart(XmlPullParser parser) throws XmlPullParserException, IOException {
		XmlPullParserUtil.parseStartTag(parser, getElementName());
	}

	protected void readElementEnd(XmlPullParser parser) throws XmlPullParserException, IOException {
		XmlPullParserUtil.parseEndTag(parser, getElementName());
	}

	public void write(XmlSerializer serializer, Meta meta) throws IOException {
		serializer.startTag(SyncMLConstants.SYNCML_NS, getElementName());
		writeContent(serializer, meta);
		serializer.endTag(SyncMLConstants.SYNCML_NS, getElementName());
	}

	protected Chal readOptionalChal(XmlPullParser parser) throws XmlPullParserException, IOException {
		return XmlPullParserUtil.isAtStartTag(parser, Chal.ELEMENT_NAME) ? new Chal(parser) : null;
	}

	protected Cred readOptionalCred(XmlPullParser parser, Meta meta) throws XmlPullParserException, IOException {
		return XmlPullParserUtil.isAtStartTag(parser, Cred.ELEMENT_NAME) ? new Cred(parser, meta) : null;
	}

	protected String readOptionalLang(XmlPullParser parser) throws XmlPullParserException, IOException {
		return XmlPullParserUtil.readOptionalText(parser, SimpleElements.LANG);
	}

	protected Data readOptionalData(XmlPullParser parser, Meta meta) throws XmlPullParserException, IOException {
		return XmlPullParserUtil.isAtStartTag(parser, Data.ELEMENT_NAME) ? new Data(parser, meta) : null;
	}

	protected Meta readOptionalMeta(XmlPullParser parser, Meta meta) throws XmlPullParserException, IOException {
		return XmlPullParserUtil.isAtStartTag(parser, Meta.ELEMENT_NAME) ? new Meta(parser) : meta;
	}

	protected Source readOptionalSource(XmlPullParser parser) throws XmlPullParserException, IOException {
		return XmlPullParserUtil.isAtStartTag(parser, Source.ELEMENT_NAME) ? new Source(parser) : null;
	}

	protected Target readOptionalTarget(XmlPullParser parser) throws XmlPullParserException, IOException {
		return XmlPullParserUtil.isAtStartTag(parser, Target.ELEMENT_NAME) ? new Target(parser) : null;
	}

	protected void readItems(XmlPullParser parser, Meta meta, List<Item> items, int minCount)
			throws XmlPullParserException, IOException {
		while (XmlPullParserUtil.isAtStartTag(parser, Item.ELEMENT_NAME))
			items.add(new Item(parser, meta));
		checkItemCount(items, minCount, "Item");
	}

	private void checkItemCount(List<?> items, int minCount, String name) throws XmlPullParserException {
		if (items.size() < minCount)
			throw new XmlPullParserException("Expected at least " + minCount + " " + name + "s, got " + items.size());
	}

	protected void writeItems(XmlSerializer serializer, Meta meta, List<Item> items) throws IOException {
		for (Item i : items)
			i.write(serializer, meta);
	}

	protected void readCommands(XmlPullParser parser, Meta meta, List<SyncMLCommand> commands, int minCount)
			throws XmlPullParserException, IOException {
		for (;;) {
			XmlPullParserUtil.skipWhitespace(parser);
			if (parser.getEventType() != XmlPullParser.START_TAG)
				break;
			String tag = parser.getName();
			if (tag.equals(SimpleElements.FINAL))
				break;
			commands.add(SyncMLCommandFactory.readCommand(parser, meta, tag));
		}
		checkItemCount(commands, minCount, "Command");
	}

	protected void requireElement(XmlPullParser parser, int element) throws XmlPullParserException, IOException {
		parser.require(element, null, null);
		parser.next();
	}

	protected abstract void writeContent(XmlSerializer serializer, Meta meta) throws IOException;
}
