/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.config;

import static com.openexchange.usm.syncml.SyncMLConstants.*;

import java.util.EnumSet;
import java.util.List;
import java.util.Map.Entry;

import com.openexchange.usm.api.USMVersion;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.syncml.*;
import com.openexchange.usm.syncml.commands.Get;
import com.openexchange.usm.syncml.elements.*;
import com.openexchange.usm.syncml.elements.xml.ComposedXMLPart;
import com.openexchange.usm.syncml.elements.xml.SimpleXMLPart;
import com.openexchange.usm.syncml.exceptions.SyncMLException;
import com.openexchange.usm.syncml.mapping.ContentTypeMapping;
import com.openexchange.usm.syncml.mapping.ContentTypeMappings;
import com.openexchange.usm.syncml.servlet.SyncMLRequest;
import com.openexchange.usm.syncml.util.MimeTypeUtil;

public class DeviceInfo {

	// TODO Add SERVER_ALERTED_SYNC ?
	private final static EnumSet<SyncType> SUPPORTED_SYNC_TYPES = EnumSet.of(SyncType.TWO_WAY_SYNC, SyncType.SLOW_SYNC);

	public static boolean isDeviceInfoRequest(Source loc, Meta meta) {
		if (meta == null || !DEVINF_TYPE.equals(MimeTypeUtil.getBaseMimeType(meta.getXMLData(SyncMLConstants.TYPE))))
			return false;
		if (loc == null || !loc.getLocURI().startsWith(DEVINF_TARGET))
			return false;
		try {
			int version = Integer.parseInt(loc.getLocURI().substring(DEVINF_TARGET.length()));
			return (version >= DEVINF_LOWER_VERSION_LIMIT && version <= DEVINF_UPPER_VERSION_LIMIT);
		} catch (NumberFormatException ignored) {
			return false;
		}
	}

	public static Item getDeviceInfo(SyncMLRequest syncMLRequest, Meta meta, Source source) throws SyncMLException {
		try {
			Session session = syncMLRequest.getUSMSession();
			ComposedXMLPart xml = new ComposedXMLPart(SyncMLConstants.DEV_INFO, MimeTypeUtil.buildXmlEncodedMimeType(
					SyncMLConstants.NS_SYNCML_DEVINF, syncMLRequest.isWbxml()));
			xml.addXMLData("1.1", SimpleElements.VER_DTD);
			xml.addXMLData("Open-Xchange GmbH", MAN);
			xml.addXMLData("USM/SyncML", MOD);
			xml.addXMLData("Open-Xchange", OEM);
			xml.addXMLData("-", FWV);
			xml.addXMLData(USMVersion.VERSION_BUILD, SWV);
			xml.addXMLData("-", HWV);
			xml.addXMLData(session.getContextUUID().toString(), DEV_ID);
			xml.addXMLData("server", DEV_TYP);
			xml.addXMLData("", SUPPORT_LARGE_OBJ);
			for (Entry<String, Folder> e : syncMLRequest.getFolders().entrySet())
				addFolderInfo(xml, e);
			ComposedXMLPart ctCap = new ComposedXMLPart(CT_CAP, null);
			for (ContentTypeMapping ctm : ContentTypeMappings.getAllMappings())
				ctm.addFieldDescriptionList(ctCap);
			xml.add(ctCap);
			return new Item(null, source, meta, new Data(xml));
		} catch (USMException e) {
			throw new SyncMLException(SyncMLBundleErrorCodes.DEVICE_INFO_COULD_NOT_BE_RETRIEVED,
					SyncMLStatusCode.COMMAND_FAILED, "Error retrieving device info", e);
		}
	}

	public static Get getDeviceInfoRequest(boolean wbxml) {
		Meta meta = getDevInfMeta(wbxml);
		Item item = new Item(new Target(DEVINF_TARGET_DEFAULT, DEVINF_TARGET_DEFAULT), null, null, null);
		return new Get(meta, item);
	}

	public static Meta getDevInfMeta(boolean wbxml) {
		return new Meta(new SimpleXMLPart(TYPE, null, MimeTypeUtil.buildXmlEncodedMimeType(DEVINF_TYPE, wbxml)));
	}

	private static void addFolderInfo(ComposedXMLPart xml, Entry<String, Folder> e) {
		Folder f = e.getValue();
		List<ContentTypeMapping> mappings = ContentTypeMappings.getMappings(f.getElementsContentType());
		if (mappings == null || mappings.isEmpty())
			return;
		ComposedXMLPart part = new ComposedXMLPart(DATA_STORE, null);
		part.addXMLData(e.getKey(), SimpleElements.SOURCE_REF);
		part.addXMLData(String.valueOf(f.getFieldContent("title")), DISPLAY_NAME);
		part.addXMLData("32", MAX_GUID_SIZE);
		addSupportedTransferMimeTypes(mappings, part, RX_PREF, RX);
		addSupportedTransferMimeTypes(mappings, part, TX_PREF, TX);
		for (SyncType syncType : SUPPORTED_SYNC_TYPES)
			part.addXMLData(syncType.getEncodedType(), SYNC_CAP, SYNC_TYPE);
		xml.add(part);
	}

	private static void addSupportedTransferMimeTypes(List<ContentTypeMapping> mappings, ComposedXMLPart part,
			String pref, String normal) {
		boolean hadPreferred = false;
		for (ContentTypeMapping ctm : mappings) {
			ComposedXMLPart desc = new ComposedXMLPart(hadPreferred ? normal : pref, null);
			desc.addXMLData(ctm.getMimeType(), CT_TYPE);
			desc.addXMLData(ctm.getVersion(), VER_CT);
			hadPreferred = true;
			part.add(desc);
		}
	}
}
