/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.config;

import java.util.HashMap;
import java.util.Map;

import com.openexchange.usm.api.contenttypes.DefaultContentTypes;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.*;

public class CompleteFolderHierarchy extends FolderHierarchy {
	protected final static Folder[] EMPTY_FOLDERS = new Folder[0];
	protected final static int STANDARD_CONTACTS_FOLDER = 3;

	/**
	 * Reads the current Folder hierarchy from the OX server, and builds a representation for SyncML.
	 * This method should only be called by the SyncMLRequest, other objects (and even methods from
	 * this class and its sub-classes) should use the methods provided by SyncMLRequest that perform
	 * caching. 
	 */
	@Override
	public Map<String, Folder> getFolders(Session usmSession) throws USMException {
		DataObject[] folders = usmSession.syncFoldersWithServer(Session.NO_LIMIT, null, false,
				ConflictResolution.USE_SERVER).getNewState();
		Map<String, Folder> data = new HashMap<String, Folder>();
		Map<Folder, String> temp = new HashMap<Folder, String>();
		Map<String, Folder> idMap = new HashMap<String, Folder>();
		// build lookup map for folder by ID
		for (DataObject o : folders)
			idMap.put(o.getID(), (Folder) o);
		// build result map, by computing the local URI for each folder
		for (DataObject o : folders)
			computeLocalURI(data, temp, idMap, (Folder) o);
		return data;
	}

	protected String computeLocalURI(Map<String, Folder> data, Map<Folder, String> temp, Map<String, Folder> idMap,
			Folder f) {
		String locURI = temp.get(f);
		if (locURI == null) { // Not already computed ?
			locURI = String.valueOf(f.getFieldContent("title"));
			String parentFolderID = f.getParentFolderID();
			if (parentFolderID != null && !parentFolderID.equals("1")) {
				Folder parent = idMap.get(parentFolderID);
				if (parent != null) // We have a parent, compose the local URI from the parents local URI and the current elements title
					locURI = computeLocalURI(data, temp, idMap, parent) + "/" + locURI;
			}
			data.put(locURI, f);
			temp.put(f, locURI);
		}
		return locURI;
	}

	@Override
	public Folder getFolder(Map<String, Folder> map, String locURI) throws USMException {
		if (locURI.startsWith("./"))
			locURI = locURI.substring(2);
		return map.get(locURI);
	}

	protected Folder getStandardContactsFolder(DataObject[] candidates) {
		//look for standard folder, and return it
		Folder rootContactsFolder = null;
		Folder contactsFolder = null;
		for (DataObject o : candidates) {
			Folder f = (Folder) o;
			if (isContactsFolder(f)) {
				if (isStandardContactsFolder(f))
					return f;
				if (rootContactsFolder == null && isRootFolder(f))
					rootContactsFolder = f;
				else if (contactsFolder == null)
					contactsFolder = f;
			}
		}
		// if no standard folder found return the first root contacts folder, or if that was not found, the first contacts folder found
		return (rootContactsFolder != null) ? rootContactsFolder : contactsFolder;
	}

	protected boolean isRootFolder(Folder f) {
		return "0".equals(f.getParentFolderID());
	}

	protected boolean isContactsFolder(Folder f) {
		return DefaultContentTypes.CONTACTS_ID.equals(f.getElementsContentTypeID());
	}

	protected boolean isStandardContactsFolder(Folder f) {
		Object o = f.getFieldContent("standard_folder");
		if (!(o instanceof Boolean) || !((Boolean) o).booleanValue())
			return false;
		o = f.getFieldContent("standard_folder_type");
		if (!(o instanceof Number) || ((Number) o).intValue() != STANDARD_CONTACTS_FOLDER)
			return false;
		return true;
	}
}
