/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.commands;

import java.util.*;
import java.util.Map;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.*;
import com.openexchange.usm.syncml.SyncMLConstants;
import com.openexchange.usm.syncml.SyncMLStatusCode;
import com.openexchange.usm.syncml.data.SyncMLProtocolInfo;
import com.openexchange.usm.syncml.elements.Item;
import com.openexchange.usm.syncml.elements.Meta;
import com.openexchange.usm.syncml.mapping.ContentTypeMapping;
import com.openexchange.usm.syncml.mapping.ContentTypeMappings;
import com.openexchange.usm.syncml.servlet.SyncMLRequest;

public abstract class SyncOperationCommand extends BaseSyncCommand {

	private SyncMLStatusCode _status;

	public void addDataObjectsForCommand(SyncMLRequest syncMLRequest, List<DataObject> elements,
			ContentType contentType, Map<String, DataObject> clientIDMap) {
		_status = addDataObjectRequests(syncMLRequest, elements, contentType, clientIDMap);
	}

	public void addStatusForCommand(SyncResult result, SyncMLRequest syncMLRequest) {
		java.util.Map<DataObject, USMException> errors = result.getErrors();
		String sourceRef = null;
		List<String> deviceObjectsList = new ArrayList<String>();
		for (Item item : getItems()) {
			String source = item.getSource().getLocURI();
			if (sourceRef == null)
				sourceRef = source;
			deviceObjectsList.add(source);
		}
		if (_status == null) {
			for (DataObject obj : errors.keySet()) {
				ProtocolInformation info = obj.getProtocolInformation();
				if (info instanceof SyncMLProtocolInfo) {
					String source = ((SyncMLProtocolInfo) info).getDeviceObjectID();
					if (deviceObjectsList.contains(source)) {
						_status = SyncMLStatusCode.COMMAND_FAILED;
						sourceRef = source;
						break;
					}
				}
			}
		}
		syncMLRequest.addStatusForCommand(this, null, sourceRef, _status == null ? SyncMLStatusCode.OK : _status);
	}

	protected ContentTypeMapping getContentTypeMapping(Item item) {
		Meta meta = item.getMeta();
		return (meta == null) ? null : ContentTypeMappings.getMapping(meta.getXMLData(SyncMLConstants.TYPE));
	}

	public abstract Meta getMeta();

	protected abstract List<Item> getItems();

	protected abstract SyncMLStatusCode addDataObjectRequests(SyncMLRequest syncMLRequest, List<DataObject> elements,
			ContentType contentType, Map<String, DataObject> clientIDMap);
}
