/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.commands;

import java.io.IOException;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import com.openexchange.usm.syncml.SyncMLStatusCode;
import com.openexchange.usm.syncml.elements.Meta;
import com.openexchange.usm.syncml.elements.SimpleElements;
import com.openexchange.usm.syncml.parser.XmlPullParserUtil;

public class SyncMLCommandFactory {
	private final static String[] UNIMPLEMENTED_COMMANDS = { "Atomic", "Exec", "Search" };

	public static SyncMLCommand readCommand(XmlPullParser parser, Meta meta, String tag) throws XmlPullParserException,
			IOException {
		int depth = parser.getDepth();
		if (parser.getEventType() != XmlPullParser.START_TAG)
			throw new XmlPullParserException("Invalid XML data in command list");
		String name = parser.getName();
		parser.next();
		String cmdID = XmlPullParserUtil.readText(parser, SimpleElements.CMD_ID);
		try {
			try {
				if (name.equals(Add.ELEMENT_NAME))
					return new Add(parser, meta, cmdID);
				if (name.equals(Alert.ELEMENT_NAME))
					return new Alert(parser, meta, cmdID);
				if (name.equals(Copy.ELEMENT_NAME))
					return new Copy(parser, meta, cmdID);
				if (name.equals(Delete.ELEMENT_NAME))
					return new Delete(parser, meta, cmdID);
				if (name.equals(Get.ELEMENT_NAME))
					return new Get(parser, meta, cmdID);
				if (name.equals(Map.ELEMENT_NAME))
					return new Map(parser, meta, cmdID);
				if (name.equals(Put.ELEMENT_NAME))
					return new Put(parser, meta, cmdID);
				if (name.equals(Replace.ELEMENT_NAME))
					return new Replace(parser, meta, cmdID);
				if (name.equals(Results.ELEMENT_NAME))
					return new Results(parser, meta, cmdID);
				if (name.equals(Sequence.ELEMENT_NAME))
					return new Sequence(parser, meta, cmdID);
				if (name.equals(Status.ELEMENT_NAME))
					return new Status(parser, meta, cmdID);
				if (name.equals(Sync.ELEMENT_NAME))
					return new Sync(parser, meta, cmdID);
				// TODO Check if the status code for optional commands is correct, or if we should also return COMMAND_NOT_IMPLEMENTED for them
				for (String cmd : UNIMPLEMENTED_COMMANDS) {
					if (name.equals(cmd))
						return new UnknownCommand(parser, name, cmdID, SyncMLStatusCode.OPTIONAL_FEATURE_NOT_SUPPORTED);
				}
				return new UnknownCommand(parser, name, cmdID, SyncMLStatusCode.COMMAND_NOT_IMPLEMENTED);
			} catch (XmlPullParserException e) {
				// Error occurred during parsing of valid command
				return new UnknownCommand(parser, name, cmdID, SyncMLStatusCode.BAD_REQUEST);
			}
		} finally {
			// Try to make sure that even on an error we read all remaining data of the command so that we can restart on the next command or end of command list
			try {
				while ((parser.getEventType() == XmlPullParser.END_TAG) ? parser.getDepth() >= depth : parser
						.getDepth() > depth)
					parser.next();
			} catch (XmlPullParserException e) {
			} catch (IOException e) {
			}
		}
	}
}
