/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.xmlpull.v1.*;

import com.openexchange.usm.syncml.elements.*;
import com.openexchange.usm.syncml.exceptions.SyncMLException;
import com.openexchange.usm.syncml.parser.XmlPullParserUtil;
import com.openexchange.usm.syncml.servlet.SyncMLRequest;

public class Status extends BaseCommand {
	public static final String ELEMENT_NAME = "Status";

	private final int _msgRef;
	private final String _cmdRef;
	private final String _cmd;
	private final String _targetRef;
	private final String _sourceRef;
	private final Cred _cred;
	private final Chal _chal;
	private final Data _data;
	private final List<Item> _items = new ArrayList<Item>();

	public Status(SyncHdr syncHdr, Cred cred, Chal chal, Data data, Item... items) {
		_msgRef = syncHdr.getMsgID();
		_cmdRef = "0";
		_cmd = syncHdr.getElementName();
		_targetRef = syncHdr.getTarget().getLocURI();
		_sourceRef = syncHdr.getSource().getLocURI();
		_cred = cred;
		_chal = chal;
		_data = data;
		for (Item i : items)
			_items.add(i);
	}

	public Status(int msgRef, SyncMLCommand command, String targetRef, String sourceRef, Cred cred, Chal chal,
			Data data, Item... items) {
		_msgRef = msgRef;
		_cmdRef = command.getCmdID();
		_cmd = command.getElementName();
		_targetRef = targetRef;
		_sourceRef = sourceRef;
		_cred = cred;
		_chal = chal;
		_data = data;
		for (Item i : items)
			_items.add(i);
	}

	public Status(XmlPullParser parser, Meta meta, String cmdID) throws XmlPullParserException, IOException {
		setCmdID(cmdID);
		_msgRef = XmlPullParserUtil.readInteger(parser, SimpleElements.MSG_REF, 1, Integer.MAX_VALUE);
		_cmdRef = XmlPullParserUtil.readText(parser, SimpleElements.CMD_REF);
		_cmd = XmlPullParserUtil.readText(parser, SimpleElements.CMD);
		_targetRef = XmlPullParserUtil.readOptionalText(parser, SimpleElements.TARGET_REF);
		_sourceRef = XmlPullParserUtil.readOptionalText(parser, SimpleElements.SOURCE_REF);
		_cred = readOptionalCred(parser, meta);
		_chal = readOptionalChal(parser);
		_data = new Data(parser, null);
		readItems(parser, meta, _items, 0);
		readElementEnd(parser);
	}

	public String getElementName() {
		return ELEMENT_NAME;
	}

	@Override
	protected void writeContent(XmlSerializer serializer, Meta meta) throws IOException {
		super.writeContent(serializer, meta);
		XmlPullParserUtil.writeText(serializer, SimpleElements.MSG_REF, String.valueOf(_msgRef));
		XmlPullParserUtil.writeText(serializer, SimpleElements.CMD_REF, _cmdRef);
		XmlPullParserUtil.writeText(serializer, SimpleElements.CMD, _cmd);
		XmlPullParserUtil.writeOptionalText(serializer, SimpleElements.TARGET_REF, _targetRef);
		XmlPullParserUtil.writeOptionalText(serializer, SimpleElements.SOURCE_REF, _sourceRef);
		if (_cred != null)
			_cred.write(serializer, meta);
		if (_chal != null)
			_chal.write(serializer, meta);
		_data.write(serializer, meta);
		writeItems(serializer, meta, _items);
	}

	public boolean isNoResp() {
		return true;
	}

	public void execute(SyncMLRequest syncMLRequest) throws SyncMLException {
		// Nothing to do (?)
	}
}
