/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.xmlpull.v1.*;

import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.session.dataobject.DataObjectSet;
import com.openexchange.usm.syncml.SyncMLStatusCode;
import com.openexchange.usm.syncml.data.SyncMLProtocolInfo;
import com.openexchange.usm.syncml.elements.*;
import com.openexchange.usm.syncml.exceptions.SyncMLException;
import com.openexchange.usm.syncml.parser.XmlPullParserUtil;
import com.openexchange.usm.syncml.servlet.SyncMLRequest;
import com.openexchange.usm.syncml.sync.SyncInformation;

/**
 * 
 * @author afe
 *
 */
public class Map extends BaseCommand {
	public static final String ELEMENT_NAME = "Map";

	private final Target _target;
	private final Source _source;
	private final Cred _cred;
	private final Meta _meta;
	private final List<MapItem> _items = new ArrayList<MapItem>();

	public Map(XmlPullParser parser, Meta meta, String cmdID) throws XmlPullParserException, IOException {
		setCmdID(cmdID);
		_target = new Target(parser);
		_source = new Source(parser);
		_cred = readOptionalCred(parser, meta);
		_meta = readOptionalMeta(parser, meta);
		while (XmlPullParserUtil.isAtStartTag(parser, MapItem.ELEMENT_NAME))
			_items.add(new MapItem(parser, _meta));
		readElementEnd(parser);
	}

	public String getElementName() {
		return ELEMENT_NAME;
	}

	@Override
	protected void writeContent(XmlSerializer serializer, Meta meta) throws IOException {
		super.writeContent(serializer, meta);
		_target.write(serializer, meta);
		_source.write(serializer, meta);
		if (_cred != null)
			_cred.write(serializer, meta);
		if (_meta != null) {
			_meta.write(serializer, meta);
			meta = _meta;
		}
		for (MapItem i : _items)
			i.write(serializer, meta);
	}

	public boolean isNoResp() {
		return false;
	}

	@Override
	public boolean isSyncAction() {
		return true;
	}

	public void execute(SyncMLRequest syncMLRequest) throws SyncMLException {
		SyncMLStatusCode status = performMap(syncMLRequest);
		syncMLRequest.addStatusForCommand(this, _target.getLocURI(), _source.getLocURI(), status);
	}

	private SyncMLStatusCode performMap(SyncMLRequest syncMLRequest) throws SyncMLException {
		//Store mapping for client ids in SyncState, create status
		SyncInformation syncInfo = syncMLRequest.getSyncInformation(_source.getLocURI(), _target.getLocURI());
		if (syncInfo == null)
			return SyncMLStatusCode.BAD_REQUEST;
		DataObject[] oldSyncState = syncInfo.getNewSyncState();
		if (oldSyncState == null)
			return SyncMLStatusCode.BAD_REQUEST;
		SyncMLStatusCode returnCode = SyncMLStatusCode.OK;
		DataObjectSet set = new DataObjectSet(oldSyncState);
		for (MapItem item : _items) {
			DataObject object = set.get(item.getTarget().getLocURI());
			if (object != null) {
				object.setProtocolInformation(new SyncMLProtocolInfo(item.getSource().getLocURI()));
				object.commitChanges();
				syncInfo.setSyncStateChanged();
			} else {
				returnCode = SyncMLStatusCode.BAD_REQUEST; // Do not fail completely on missed lookup, but indicate error
			}
		}
		return returnCode;
	}
}
