/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.xmlpull.v1.*;

import com.openexchange.usm.syncml.SyncMLBundleErrorCodes;
import com.openexchange.usm.syncml.SyncMLStatusCode;
import com.openexchange.usm.syncml.elements.*;
import com.openexchange.usm.syncml.exceptions.SyncMLException;
import com.openexchange.usm.syncml.servlet.SyncMLRequest;

public class Copy extends BaseCommand {
	public static final String ELEMENT_NAME = "Copy";

	private final boolean _noResp;
	private final Cred _cred;
	private final Meta _meta;
	private final List<Item> _items = new ArrayList<Item>();

	public Copy(XmlPullParser parser, Meta meta, String cmdID) throws XmlPullParserException, IOException {
		setCmdID(cmdID);
		_noResp = readNoResp(parser);
		_cred = readOptionalCred(parser, meta);
		_meta = readOptionalMeta(parser, meta);
		readItems(parser, _meta, _items, 1);
		readElementEnd(parser);
	}

	public String getElementName() {
		return ELEMENT_NAME;
	}

	@Override
	protected void writeContent(XmlSerializer serializer, Meta meta) throws IOException {
		super.writeContent(serializer, meta);
		writeNoResp(serializer, _noResp);
		if (_cred != null)
			_cred.write(serializer, meta);
		if (_meta != null) {
			_meta.write(serializer, meta);
			meta = _meta;
		}
		writeItems(serializer, meta, _items);
	}

	public boolean isNoResp() {
		return _noResp;
	}

	public void execute(SyncMLRequest syncMLRequest) throws SyncMLException {
		// TODO We should implement the copy command if any device uses it. Implementation may be problematic !
		throw new SyncMLException(SyncMLBundleErrorCodes.CAN_NOT_EXECUTE_COPY_COMMAND, SyncMLStatusCode.COMMAND_FAILED,
				"Copy command not implemented");
	}
}
