/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml;

public class SyncMLConstants {

	// If set, the SyncML bundle performs some integrity checks regarding the sync data (especially if all client IDs are present)
	public final static boolean PERFORM_INTEGRITY_CHECKS = true;

	// Default value of NoResp-Flag for all commands that do not use explicit settings
	public final static boolean NO_RESP_DEFAULT = false;

	public final static String UTF_8 = "UTF-8";

	public final static String PROTOCOL_NAME = "SyncML";

	public final static String SYNCML_NS = "SYNCML:SYNCML1.0";

	// namespace syncml:metinf

	public final static String NS_SYNCML_METINF = "syncml:metinf";

	public final static String ANCHOR = "Anchor";

	public final static String LAST = "Last";

	public final static String NEXT = "Next";

	public final static String TYPE = "Type";

	public final static String FORMAT = "Format";

	public final static String SYNCML_AUTH_BASIC = "syncml:auth-basic";

	public final static String FORMAT_B64 = "b64";

	public final static String MAX_MSG_SIZE = "MaxMsgSize";

	// namespace: syncml:devinf

	public final static String NS_SYNCML_DEVINF = "syncml:devinf";

	public final static String DEV_INFO = "DevInf";

	public final static String VER_CT = "VerCT";

	public final static String CT_TYPE = "CTType";

	public final static String TX = "Tx";

	public final static String TX_PREF = "Tx-Pref";

	public final static String RX = "Rx";

	public final static String RX_PREF = "Rx-Pref";

	public final static String DISPLAY_NAME = "DisplayName";

	public final static String DATA_STORE = "DataStore";

	public final static String SYNC_TYPE = "SyncType";

	public final static String SYNC_CAP = "SyncCap";

	public final static String CT_CAP = "CTCap";

	public final static String DEV_TYP = "DevTyp";

	public final static String DEV_ID = "DevID";

	public final static String OEM = "OEM";

	public final static String MOD = "Mod";

	public final static String MAN = "Man";

	public final static String DEVINF_TYPE = "application/vnd.syncml-devinf";

	public final static String DEVINF_TARGET = "./devinf";

	public final static String DEVINF_TARGET_DEFAULT = "./devinf11";

	public final static int DEVINF_LOWER_VERSION_LIMIT = 10;

	public final static int DEVINF_UPPER_VERSION_LIMIT = 11;

	public static final String PARAM_NAME = "ParamName";

	public static final String VAL_ENUM = "ValEnum";

	public static final String PROP_NAME = "PropName";

	public static final String MAX_GUID_SIZE = "MaxGUIDSize";

	public static final String FWV = "FwV";

	public static final String SWV = "SwV";

	public static final String HWV = "HwV";

	public static final String SUPPORT_LARGE_OBJ = "SupportLargeObjs";

}
