/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.test;

import static com.openexchange.usm.api.datatypes.DataTypes.*;

import java.io.Serializable;

import com.openexchange.usm.api.contenttypes.*;
import com.openexchange.usm.api.datatypes.*;
import com.openexchange.usm.api.exceptions.DeserializationFailedException;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.contenttypes.util.UtilConstants;
import com.openexchange.usm.datatypes.contacts.ContactDistributionMemberDataType;
import com.openexchange.usm.datatypes.contacts.ImageDataType;

/**
 * @author afe
 *
 */
public class SimContactContentType implements ContentType {
	private final static ContentTypeField[] FIELDS = {
	//Common object data
			new ContentTypeField(1, UtilConstants.FIELD_ID, STRING, false, true, false, false),// Object ID
			new ContentTypeField(20, UtilConstants.FOLDER_ID, STRING, false, false, true, false), //Object ID of the parent folder. 
			new ContentTypeField(2, UtilConstants.CREATED_BY, STRING), //User ID of the user who created this object. 
			new ContentTypeField(3, UtilConstants.MODIFIED_BY, STRING), //User ID of the user who last modified this object. 
			new ContentTypeField(4, UtilConstants.CREATION_DATE, TIME), //Date and time of creation.
			new ContentTypeField(5, UtilConstants.LAST_MODIFIED, TIME), //Date and time of the last modification. 
			new ContentTypeField(100, UtilConstants.CATEGORIES, STRING), //Array - Each element is a string, naming a category. Order is preserved. Changing the order counts as modification of the object. 
			//Not present in folder objects. 
			new ContentTypeField(101, ContactConstants.PRIVATE_FLAG, BOOLEAN), //Overrides folder permissions in shared private folders: When true, this object is not visible to anyone except the owner. Not present in folder objects. 
			new ContentTypeField(104, ContactConstants.NUMBER_OF_ATTACHMENTS, NUMBER), //Number of attachments 
			// detailed contact data 
			new ContentTypeField(500, ContactConstants.DISPLAY_NAME, STRING),
			new ContentTypeField(501, ContactConstants.FIRST_NAME, STRING),
			new ContentTypeField(502, ContactConstants.LAST_NAME, STRING),
			new ContentTypeField(503, ContactConstants.SECOND_NAME, STRING),
			new ContentTypeField(504, ContactConstants.SUFFIX, STRING),
			new ContentTypeField(505, ContactConstants.TITLE, STRING),
			new ContentTypeField(506, ContactConstants.STREET_HOME, STRING),
			new ContentTypeField(507, ContactConstants.POSTAL_CODE_HOME, STRING),
			new ContentTypeField(508, ContactConstants.CITY_HOME, STRING),
			new ContentTypeField(509, ContactConstants.STATE_HOME, STRING),
			new ContentTypeField(510, ContactConstants.COUNTRY_HOME, STRING),
			new ContentTypeField(511, ContactConstants.BIRTHDAY, DATE),
			new ContentTypeField(512, ContactConstants.MARITAL_STATUS, STRING),
			new ContentTypeField(513, ContactConstants.NUMBER_OF_CHILDREN, STRING),
			new ContentTypeField(514, ContactConstants.PROFESSION, STRING),
			new ContentTypeField(515, ContactConstants.NICKNAME, STRING),
			new ContentTypeField(516, ContactConstants.SPOUSE_NAME, STRING),
			new ContentTypeField(517, ContactConstants.ANNIVERSARY, DATE),
			new ContentTypeField(518, ContactConstants.NOTE, STRING),
			new ContentTypeField(519, ContactConstants.DEPARTMENT, STRING),
			new ContentTypeField(520, ContactConstants.POSITION, STRING),
			new ContentTypeField(521, ContactConstants.EMPLOYEE_TYPE, STRING),
			new ContentTypeField(522, ContactConstants.ROOM_NUMBER, STRING),
			new ContentTypeField(523, ContactConstants.STREET_BUSINESS, STRING),
			new ContentTypeField(525, ContactConstants.POSTAL_CODE_BUSINESS, STRING),
			new ContentTypeField(526, ContactConstants.CITY_BUSINESS, STRING),
			new ContentTypeField(527, ContactConstants.STATE_BUSINESS, STRING),
			new ContentTypeField(528, ContactConstants.COUNTRY_BUSINESS, STRING),
			new ContentTypeField(529, ContactConstants.NUMBER_OF_EMPLOYEES, STRING),
			new ContentTypeField(530, ContactConstants.SALES_VOLUME, STRING),
			new ContentTypeField(531, ContactConstants.TAX_ID, STRING),
			new ContentTypeField(532, ContactConstants.COMMERCIAL_REGISTER, STRING),
			new ContentTypeField(533, ContactConstants.BRANCHES, STRING),
			new ContentTypeField(534, ContactConstants.BUSINESS_CATEGORY, STRING),
			new ContentTypeField(535, ContactConstants.INFO, STRING),
			new ContentTypeField(536, ContactConstants.MANAGER_NAME, STRING),
			new ContentTypeField(537, ContactConstants.ASSISTANT_NAME, STRING),
			new ContentTypeField(538, ContactConstants.STREET_OTHER, STRING),
			new ContentTypeField(539, ContactConstants.CITY_OTHER, STRING),
			new ContentTypeField(540, ContactConstants.POSTAL_CODE_OTHER, STRING),
			new ContentTypeField(541, ContactConstants.COUNTRY_OTHER, STRING),
			new ContentTypeField(542, ContactConstants.TELEPHONE_BUSINESS1, STRING),
			new ContentTypeField(543, ContactConstants.TELEPHONE_BUSINESS2, STRING),
			new ContentTypeField(544, ContactConstants.FAX_BUSINESS, STRING),
			new ContentTypeField(545, ContactConstants.TELEPHONE_CALLBACK, STRING),
			new ContentTypeField(546, ContactConstants.TELEPHONE_CAR, STRING),
			new ContentTypeField(547, ContactConstants.TELEPHONE_COMPANY, STRING),
			new ContentTypeField(548, ContactConstants.TELEPHONE_HOME1, STRING),
			new ContentTypeField(549, ContactConstants.TELEPHONE_HOME2, STRING),
			new ContentTypeField(550, ContactConstants.FAX_HOME, STRING),
			new ContentTypeField(551, ContactConstants.CELLULAR_TELEPHONE1, STRING),
			new ContentTypeField(552, ContactConstants.CELLULAR_TELEPHONE2, STRING),
			new ContentTypeField(553, ContactConstants.TELEPHONE_OTHER, STRING),
			new ContentTypeField(554, ContactConstants.FAX_OTHER, STRING),
			new ContentTypeField(555, ContactConstants.EMAIL1, STRING),
			new ContentTypeField(556, ContactConstants.EMAIL2, STRING),
			new ContentTypeField(557, ContactConstants.EMAIL3, STRING),
			new ContentTypeField(558, ContactConstants.URL, STRING),
			new ContentTypeField(559, ContactConstants.TELEPHONE_ISDN, STRING),
			new ContentTypeField(560, ContactConstants.TELEPHONE_PAGER, STRING),
			new ContentTypeField(561, ContactConstants.TELEPHONE_PRIMARY, STRING),
			new ContentTypeField(562, ContactConstants.TELEPHONE_RADIO, STRING),
			new ContentTypeField(563, ContactConstants.TELEPHONE_TELEX, STRING),
			new ContentTypeField(564, ContactConstants.TELEPHONE_TTYTDD, STRING),
			new ContentTypeField(565, ContactConstants.INSTANT_MESSENGER1, STRING),
			new ContentTypeField(566, ContactConstants.INSTANT_MESSENGER2, STRING),
			new ContentTypeField(567, ContactConstants.TELEPHONE_IP, STRING),
			new ContentTypeField(568, ContactConstants.TELEPHONE_ASSISTANT, STRING),
			new ContentTypeField(569, ContactConstants.COMPANY, STRING),
			new ContentTypeField(571, ContactConstants.USERFIELD01, STRING),
			new ContentTypeField(572, ContactConstants.USERFIELD02, STRING),
			new ContentTypeField(573, ContactConstants.USERFIELD03, STRING),
			new ContentTypeField(574, ContactConstants.USERFIELD04, STRING),
			new ContentTypeField(575, ContactConstants.USERFIELD05, STRING),
			new ContentTypeField(576, ContactConstants.USERFIELD06, STRING),
			new ContentTypeField(577, ContactConstants.USERFIELD07, STRING),
			new ContentTypeField(578, ContactConstants.USERFIELD08, STRING),
			new ContentTypeField(579, ContactConstants.USERFIELD09, STRING),
			new ContentTypeField(580, ContactConstants.USERFIELD10, STRING),
			new ContentTypeField(581, ContactConstants.USERFIELD11, STRING),
			new ContentTypeField(582, ContactConstants.USERFIELD12, STRING),
			new ContentTypeField(583, ContactConstants.USERFIELD13, STRING),
			new ContentTypeField(584, ContactConstants.USERFIELD14, STRING),
			new ContentTypeField(585, ContactConstants.USERFIELD15, STRING),
			new ContentTypeField(586, ContactConstants.USERFIELD16, STRING),
			new ContentTypeField(587, ContactConstants.USERFIELD17, STRING),
			new ContentTypeField(588, ContactConstants.USERFIELD18, STRING),
			new ContentTypeField(589, ContactConstants.USERFIELD19, STRING),
			new ContentTypeField(590, ContactConstants.USERFIELD20, STRING),
			//An array of objects containing links to other contacts. 
			//Each contact is describes by an object as defined in  Contact link data. See class ContactLink
			//If this contact is a distribution list, then this field is an array of objects. 
			//Each object describes a member of the list as defined in  Distribution list member. See class ContactDistributionMember
			new ContentTypeField(592, ContactConstants.DISTRIBUTION_LIST, new ContactDistributionMemberDataType(), true),
			new ContentTypeField(594, ContactConstants.NUMBER_OF_DISTRIBUTION_LIST, NUMBER),
			new ContentTypeField(596, ContactConstants.NUMBER_OF_IMAGES, NUMBER),
			new ContentTypeField(598, ContactConstants.STATE_OTHER, STRING),
			new ContentTypeField(599, ContactConstants.FILE_AS, STRING),
			new ContentTypeField(602, ContactConstants.MARK_AS_DISTRIBUTIONLIST, BOOLEAN),
			new ContentTypeField(605, ContactConstants.DEFAULT_ADDRESS, NUMBER),
			new ContentTypeField(102, ContactConstants.COLOR_LABEL, NUMBER),
			new ContentTypeField(524, ContactConstants.INTERNAL_USERID, NUMBER),
			// This field has to be the last field for the special handling to retrieve and store its content
			new ContentTypeField(570, ContactConstants.IMAGE1, new ImageDataType()),
			// The following fields are merged into the ImageDataType
			//			new ContentTypeField(597, "image_last_modified", DATE),
			//			new ContentTypeField(606, "image1_url", STRING)
			//			new ContentTypeField(570, "image1", STRING),
			//			new ContentTypeField(601, "image1_content_type", STRING),
			new ContentTypeField(105, UtilConstants.ATTACHMENTS_LAST_MODIFIED, new PIMAttachmentsDataType()) // New complex field that contains attachments_last_modified for updates and additionally an array PIMAttachment for persistent storing in the SyncState
	};

	public String getID() {
		return DefaultContentTypes.CONTACTS_ID;
	}

	public ContentTypeField[] getFields() {
		return FIELDS;
	}

	public DataObject newDataObject(Session session) {
		return new SimDataObject(session, this);
	}

	public ContentTypeTransferHandler getTransferHandler() {
		return null;
	}

	@Override
	public int hashCode() {
		return 31;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof SimContactContentType))
			return false;
		return true;
	}

	public int getMatchRating(DataObject client, DataObject server) {
		return -1;
	}

	public int getCode() {
		return 100;
	}

	public void deserializeData(Serializable[] data, int i, Object[] fieldContent)
			throws DeserializationFailedException {
		throw new UnsupportedOperationException();
	}

	public long createNewAttachment(DataObject object, PIMAttachment attachment) throws USMException {
		// TODO Auto-generated method stub
		return 0L;
	}

	public long deleteAttachments(DataObject object, PIMAttachment... attachmentsToDelete) throws USMException {
		// TODO Auto-generated method stub
		return 0L;
	}

	public PIMAttachments getAllAttachments(DataObject object, String sort, String order) throws USMException {
		// TODO Auto-generated method stub
		return null;
	}

	public PIMAttachments getAllAttachments(DataObject object) throws USMException {
		// TODO Auto-generated method stub
		return null;
	}

	public byte[] getAttachmentData(DataObject object, int attachmentId) throws USMException {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean supportsPIMAttachments() {
		// TODO Auto-generated method stub
		return false;
	}

	public Object getObjectGroupOwner(DataObject object) {
		// TODO Auto-generated method stub
		return object.getID();
	}

	public boolean canBeFolderElementsContentType() {
		return true;
	}
}
