/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.session.impl;

import java.io.Serializable;

import junit.framework.TestCase;

public class CachedDataTest extends TestCase {
	private final static int CACHE_SIZE = 5;

	public void testCachedData() {
		new CachedData(CACHE_SIZE);
	}

	public void testLoadFromDB() {
		CachedData cd = new CachedData(CACHE_SIZE);
		Serializable[][][] allData = new Serializable[CACHE_SIZE * 2][][];
		for (int i = 0; i < allData.length; i++) {
			allData[i] = new Serializable[1][1];
			allData[i][0][0] = "Element " + i;
		}
		for (int i = 0; i < CACHE_SIZE; i++) {
			cd.loadFromDB(i, allData[i]);
			assertEquals(allData[i], cd.get());
			assertEquals(allData[i], cd.get(i));
		}
		cd.loadFromDB(CACHE_SIZE, allData[CACHE_SIZE]);
		assertEquals(allData[CACHE_SIZE], cd.get());
		assertEquals(allData[CACHE_SIZE], cd.get(CACHE_SIZE));
		assertNull(cd.get(0));
	}

	public void testStore() {
		CachedData cd = new CachedData(CACHE_SIZE);
		Serializable[][][] allData = new Serializable[CACHE_SIZE * 2][][];
		for (int i = 0; i < allData.length; i++) {
			allData[i] = new Serializable[1][1];
			allData[i][0][0] = "Element " + i;
		}
		for (int i = 0; i < CACHE_SIZE; i++) {
			assertEquals(i, cd.loadFromDB(i, allData[i]));
			assertEquals(allData[i], cd.get());
			assertEquals(allData[i], cd.get(i));
		}
		assertEquals(CACHE_SIZE, cd.loadFromDB(CACHE_SIZE, allData[CACHE_SIZE]));
		assertEquals(allData[CACHE_SIZE], cd.get());
		assertEquals(allData[CACHE_SIZE], cd.get(CACHE_SIZE));
		assertNull(cd.get(0));
		long ts = cd.store(0, allData[0], 0L);
		assertEquals(CACHE_SIZE + 1, ts);
		assertEquals(allData[0], cd.get());
		assertEquals(allData[0], cd.get(ts));
		assertNull(cd.get(1));
		ts = cd.store(CACHE_SIZE + 2, allData[CACHE_SIZE + 2], 0L);
		assertEquals(CACHE_SIZE + 2, ts);
		assertEquals(allData[CACHE_SIZE + 2], cd.get());
		assertEquals(allData[CACHE_SIZE + 2], cd.get(ts));
		assertNull(cd.get(2));
		ts = cd.store(CACHE_SIZE + 3, allData[CACHE_SIZE + 3], 3L);
		assertEquals(CACHE_SIZE + 3, ts);
		assertEquals(allData[CACHE_SIZE + 3], cd.get());
		assertEquals(allData[CACHE_SIZE + 3], cd.get(ts));
		assertEquals(allData[3], cd.get(3));
		assertNull(cd.get(4));
		ts = cd.store(CACHE_SIZE + 4, allData[CACHE_SIZE + 4], 6L);
		assertEquals(CACHE_SIZE + 4, ts);
		assertEquals(allData[CACHE_SIZE + 4], cd.get());
		assertEquals(allData[CACHE_SIZE + 4], cd.get(ts));
		assertEquals(allData[0], cd.get(6));
		assertNull(cd.get(5));
	}
}
