/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.session.sync;

import java.util.BitSet;

import junit.framework.TestCase;

import com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Folder;

public class SimSyncContentTypeTransferHandler extends TestCase implements ContentTypeTransferHandler {

	private int _serverCalls = 0;
	public boolean _writeNewToCall = false;
	public boolean _writeUpdateToCall = false;
	public boolean _writeDeleteToCall = false;
	public boolean _writeNewCalled = false;
	public boolean _writeUpdateCalled = false;
	public boolean _writeDeleteCalled = false;
	public DataObject _objectToSend = null;

	public int getServerCalls() {
		return _serverCalls;
	}

	public void resetServerCalls() {
		_serverCalls = 0;
		_objectToSend = null;
		_writeNewToCall = false;
		_writeUpdateToCall = false;
		_writeDeleteToCall = false;
		_writeNewCalled = false;
		_writeUpdateCalled = false;
		_writeDeleteCalled = false;
		_objectToSend = null;
	}

	public void readDataObject(DataObject object, BitSet requestedFields) throws USMException {
	}

	public DataObject[] readFolderContent(Folder folder, BitSet requestedFields) throws USMException {
		return null;
	}

	public DataObject[] readUpdatedFolderContent(Folder folder, BitSet requestedFields, long timestamp)
			throws USMException {
		return null;
	}

	public void writeDeletedDataObject(DataObject object) throws USMException {
		_serverCalls++;
		if (!_writeDeleteToCall)
			fail("Write delete called when not needed!");
		assertEquals(_objectToSend, object);
		_writeDeleteCalled = true;
	}

	public void writeNewDataObject(DataObject object) throws USMException {
		_serverCalls++;
		if (!_writeNewToCall)
			fail("Write new called when not needed!");
		assertEquals(_objectToSend, object);
		_writeNewCalled = true;
	}

	public void writeUpdatedDataObject(DataObject object, long timestamp) throws USMException {
		_serverCalls++;
		if (!_writeUpdateToCall)
			fail("Write update called when not needed!");
		assertEquals(_objectToSend, object);
		_writeUpdateCalled = true;
	}

	public void checkCalls(int calls) {
		assertEquals("Incorrect number of server calls", calls, _serverCalls);
		assertEquals("write new call error", _writeNewToCall, _writeNewCalled);
		assertEquals("write updated call error", _writeUpdateToCall, _writeUpdateCalled);
		assertEquals("write delete call error", _writeDeleteToCall, _writeDeleteCalled);
	}
}
