/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.session.dataobject;

import java.util.*;

import junit.framework.TestCase;

import com.openexchange.usm.api.contenttypes.SimContentType;
import com.openexchange.usm.api.contenttypes.SimFolderContentType;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.SimSession;

public class HierarchySorterTest extends TestCase {

	List<Folder> _list = new ArrayList<Folder>();
	SimSession _session = new SimSession();
	SimFolderContentType _folderContentType = new SimFolderContentType();
	SimContentType _contentType = new SimContentType();

	protected void setUp() throws Exception {
		super.setUp();
	}

	public void testHierarchy() {
		//create all data object
		Folder folder1 = new FolderImpl(_session, _folderContentType);
		folder1.setID("a_01");
		Folder folder2 = new FolderImpl(_session, _folderContentType);
		folder2.setID("x_02");
		folder2.setParentFolder(folder1);
		Folder folder3 = new FolderImpl(_session, _folderContentType);
		folder3.setID("y_03");
		folder3.setParentFolder(folder1);
		Folder folder4 = new FolderImpl(_session, _folderContentType);
		folder4.setID("g_04");
		folder4.setParentFolder(folder3);
		Folder folder5 = new FolderImpl(_session, _folderContentType);
		folder5.setID("h_05");
		folder5.setParentFolder(folder3);
		Folder folder6 = new FolderImpl(_session, _folderContentType);
		folder6.setID("f_06");
		folder6.setParentFolder(folder1);
		Folder folder7 = new FolderImpl(_session, _folderContentType);
		folder7.setID("d_07");
		folder7.setParentFolder(folder6);
		Folder folder8 = new FolderImpl(_session, _folderContentType);
		folder8.setID("c_08");
		folder8.setParentFolder(folder6);
		Folder folder9 = new FolderImpl(_session, _folderContentType);
		folder9.setID("b_09");
		folder9.setParentFolder(folder1);
		Folder folder10 = new FolderImpl(_session, _folderContentType);
		folder10.setID("z_10");
		Folder folder11 = new FolderImpl(_session, _folderContentType);
		folder11.setID("p_11");
		folder11.setParentFolder(folder10);
		Folder folder12 = new FolderImpl(_session, _folderContentType);
		folder12.setID("o_12");
		folder12.setParentFolder(folder10);
		Folder folder13 = new FolderImpl(_session, _folderContentType);
		folder13.setID("r_13");
		folder13.setParentFolder(folder12);
		Folder folder14 = new FolderImpl(_session, _folderContentType);
		folder14.setID("s_14");
		folder14.setParentFolder(folder12);
		Folder folder15 = new FolderImpl(_session, _folderContentType);
		folder15.setID("l_15");
		folder15.setParentFolder(folder14);
		Folder folder16 = new FolderImpl(_session, _folderContentType);
		folder16.setID("m_16");
		folder16.setParentFolder(folder10);

		_list.add(folder15);
		_list.add(folder3);
		_list.add(folder16);
		_list.add(folder2);
		_list.add(folder7);
		_list.add(folder5);
		_list.add(folder12);
		_list.add(folder9);
		_list.add(folder8);
		_list.add(folder10);
		_list.add(folder13);
		_list.add(folder1);
		_list.add(folder6);
		_list.add(folder11);
		_list.add(folder14);
		_list.add(folder4);

		Folder[] array = _list.toArray(new Folder[_list.size()]);
		Collections.sort(_list, new FolderHierarchyComparator(array));
		Arrays.sort(array, new FolderHierarchyComparator(array));
		for (int i = 0; i < array.length; i++)
			assertEquals("Sort of collection and array not equal for element " + i, _list.get(i), array[i]);
		System.out.println(_list.get(0).getID());
		System.out.println(_list.get(1).getID());
		System.out.println(_list.get(2).getID());
		System.out.println(_list.get(3).getID());
		System.out.println(_list.get(4).getID());
		System.out.println(_list.get(5).getID());
		System.out.println(_list.get(6).getID());
		System.out.println(_list.get(7).getID());
		System.out.println(_list.get(8).getID());
		System.out.println(_list.get(9).getID());
		System.out.println(_list.get(10).getID());
		System.out.println(_list.get(11).getID());
		System.out.println(_list.get(12).getID());
		System.out.println(_list.get(13).getID());
		System.out.println(_list.get(14).getID());
		System.out.println(_list.get(15).getID());
	}
}
