/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.ox_json;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;

import junit.framework.TestCase;

import org.json.*;

import com.openexchange.usm.api.exceptions.AuthenticationFailedException;
import com.openexchange.usm.api.exceptions.OXCommunicationException;
import com.openexchange.usm.api.session.Session;

public class SimOXJSONAcess extends TestCase implements OXJSONAccess {

	String _validRequestPath;
	String[] _validParamsString;
	String[] _validRequestBody;
	JSONResult[] _validResultToSend;
	int _index = 0;

	public void setValidParamsString(String... validParamsString) {
		_validParamsString = validParamsString;
		_index = 0;
	}

	public void setValidRequestBody(String... validRequestBody) {
		_validRequestBody = validRequestBody;
		_index = 0;
	}

	public void setValidRequestPath(String validRequestPath) {
		_validRequestPath = validRequestPath;
	}

	public void setValidResultToSend(JSONResult... validResultToSend) {
		_validResultToSend = validResultToSend;
		_index = 0;
	}

	public JSONResult doGet(String path, String action, Session session, Map<String, String> parameters) {
		checkRequirements(path, parameters);
		return _validResultToSend[_index++];
	}

	private void checkRequirements(String path, Map<String, String> parameters) {
		assertEquals("Wrong path", _validRequestPath, path);
		Map<String, String> expectedParams = new HashMap<String, String>();
		if (_validParamsString[_index].length() > 0) {
			for (String p : _validParamsString[_index].split("&")) {
				String[] t = p.split("=", 2);
				try {
					expectedParams.put(t[0], URLDecoder.decode(t[1], "UTF-8"));
				} catch (UnsupportedEncodingException e) {
					throw new IllegalStateException("UTF-8 Encoding not found", e);
				}
			}
		}
		assertEquals("Wrong parameters", expectedParams, parameters);
	}

	public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters, JSONArray array) {
		checkRequirements(path, parameters);
		try {
			assertEquals("Wrong request body", new JSONArray(_validRequestBody[_index]).toString(3), array.toString(3));
		} catch (JSONException e) {
			throw new IllegalStateException("Expected result no JSONArray", e);
		}
		return _validResultToSend[_index++];
	}

	public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters,
			JSONObject object) {
		checkRequirements(path, parameters);
		//		assertEquals("Wrong request body", _validRequestBody[_index], object.toString());
		try {
			assertEquals("Wrong request body", new JSONObject(_validRequestBody[_index]).toString(3), object
					.toString(3));
		} catch (JSONException e) {
			throw new IllegalStateException("Expected result no JSONObject", e);
		}
		return _validResultToSend[_index++];
	}

	public void login(Session session) {
		// Do nothing
	}

	public void logout(Session session) {
		// Do nothing
	}

	public JSONObject getConfiguration(Session session, String... path) {
		return new JSONObject();
	}

	public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters, String data) {
		checkRequirements(path, parameters);
		assertEquals("Wrong request body", _validRequestBody[_index], data);
		return _validResultToSend[_index++];
	}

	public JSONResult doPut(String path, String action, Session session, Map<String, String> parameters, byte[] data) {
		String s = Arrays.toString(data);
		checkRequirements(path, parameters);
		assertEquals("Wrong request body", _validRequestBody[_index], s);
		return _validResultToSend[_index++];
	}

	public OXResource getResource(Session session, String path, Map<String, String> parameters)
			throws AuthenticationFailedException, OXCommunicationException {
		throw new UnsupportedOperationException();
	}

	public JSONResult storeResource(String path, String action, Session session, Map<String, String> parameters,
			JSONObject jsonData, byte[] imageByteData, String fileContentType) throws AuthenticationFailedException,
			OXCommunicationException {
		throw new UnsupportedOperationException();
	}

	public JSONResult storeResource(String path, String action, Session session, Map<String, String> parameters,
			JSONObject jsonData, byte[] imageByteData, String fileContentType, String jsonPartName, String filePartName)
			throws AuthenticationFailedException, OXCommunicationException {
		throw new UnsupportedOperationException();
	}
}
