/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.mapping.impl;

import java.sql.SQLException;
import java.sql.Statement;

import junit.framework.TestCase;

import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.database.EncapsulatedConnection;
import com.openexchange.usm.api.exceptions.USMSQLException;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.journal.SimJournal;
import com.openexchange.usm.mapping.*;

public class FolderIDMappingImplTest extends TestCase {

	EncapsulatedConnection _con;
	SimSessionWithDB _session;
	Journal _journal = new SimJournal();
	FolderIDMappingImpl _mapper;

	@Override
	protected void setUp() throws Exception {
		_session = new SimSessionWithDB();
		_con = _session.getWritableDBConnection();
		Statement statement = _con.createStatement();
		try {
			statement
					.executeUpdate("create table usmIdMapping (cid integer NOT NULL, usmSessionId integer NOT NULL, LongID varchar(256), ShortID integer not null)");
			statement.executeUpdate("create sequence shortIds AS INTEGER START WITH 1");
			statement.executeUpdate("create table sequence_usmIdMapping (cid integer not null, id integer not null)");
			statement.executeUpdate("insert into sequence_usmIdMapping values(0,0)");
			statement
					.executeUpdate("create unique index usmIdMappingUIDX on usmIdMapping (cid, usmSessionId, shortId)");
			statement.close();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			statement.close();
		}
		_mapper = new FolderIDMappingImpl(_journal.getLog(FolderIdMapping.class), new SimDatabaseAccessManager(_con),
				_session);
	}

	public void testSaveAndGet() {
		String longID = "456666666666666666666666666";
		int shortID;
		try {
			shortID = _mapper.getShortID(longID);
			String retrievedLongID = _mapper.getLongID(shortID);
			assertEquals("Long id not saved", longID, retrievedLongID);
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}
	}

	public void testDelete() {
		String[] longIDs = new String[10];
		int[] shortIDs = new int[10];

		try {
			for (int i = 0; i < longIDs.length; i++) {
				longIDs[i] = "4566666666666666666666666" + i;
				shortIDs[i] = _mapper.getShortID(longIDs[i]);
			}
			for (int i = 0; i < shortIDs.length; i++) {
				String retreivedLongID = _mapper.getLongID(shortIDs[i]);
				assertNotNull(retreivedLongID);
			}

			String[] idsToDelete = new String[5];
			for (int i = 0; i < idsToDelete.length; i++) {
				idsToDelete[i] = longIDs[i];
			}
			_mapper.delete(idsToDelete);

			for (int i = 0; i < 5; i++) {
				String retreivedLongID = _mapper.getLongID(shortIDs[i]);
				assertNull(retreivedLongID);
			}
			for (int i = 5; i < longIDs.length; i++) {
				String retreivedLongID = _mapper.getLongID(shortIDs[i]);
				assertNotNull(retreivedLongID);
			}
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}
	}

	public void testRetain() {
		String[] longIDs = new String[10];
		int[] shortIDs = new int[10];

		try {
			for (int i = 0; i < longIDs.length; i++) {
				longIDs[i] = "4566666666666666666666666" + i;
				shortIDs[i] = _mapper.getShortID(longIDs[i]);
			}
			for (int i = 0; i < shortIDs.length; i++) {
				String retreivedLongID = _mapper.getLongID(shortIDs[i]);
				assertNotNull(retreivedLongID);
			}

			String[] idsToRetain = new String[5];
			for (int i = 0; i < idsToRetain.length; i++) {
				idsToRetain[i] = longIDs[i];
			}
			_mapper.retain(idsToRetain);

			for (int i = 0; i < 5; i++) {
				String retreivedLongID = _mapper.getLongID(shortIDs[i]);
				assertNotNull(retreivedLongID);
			}
			for (int i = 5; i < longIDs.length; i++) {
				String retreivedLongID = _mapper.getLongID(shortIDs[i]);
				assertNull(retreivedLongID);
			}
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}
	}

	@Override
	protected void tearDown() throws Exception {
		Statement statement = _con.createStatement();
		try {
			statement.executeUpdate("drop index usmIdMappingUIDX");
			statement.executeUpdate("drop table usmIdMapping");
			statement.executeUpdate("drop sequence shortIds");
			statement.executeUpdate("drop table sequence_usmIdMapping");
		} finally {
			statement.close();
			_con.close();
		}
	}

}
