/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.test;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author ibr
 *
 */
public class USMJsonTestCase extends TestCase {

	public final static String JSONTESTS_BASEDIR = "../com.openexchange.usm.json/testfiles.local";
	private static final String USM_BASE_URL = "http://ox-p5.microdoc.dmz:80/usm-json/";
//	private static final String USM_BASE_URL = "http://localhost:8080/usm-json/";

	private static final String WAIT = "wait";
	private final static String TEXT_JAVASCRIPT_CONTENTTYPE = "text/javascript";
	private final static String CHARSET_UTF_8 = "UTF-8";

	private static class CallInfo {
		public final String _call;
		public final String _callRequest;
		public final JSONObject _expectedResponse;

		CallInfo(String call, String callRequest, JSONObject expectedResponse) {
			_call = call;
			_callRequest = callRequest;
			_expectedResponse = expectedResponse;
		}
	}

	//	private final Map<String, Object> variablesMap = new HashMap<String, Object>();
	private final List<CallInfo> callList = new ArrayList<CallInfo>();
	private final HttpClient _httpclient = new HttpClient();
	private final JSONTestReplacer _replacer = new JSONTestReplacer();
	private final String _fileName;
	private final File _fileDirectory;
	private final File _baseDirectory;

	public USMJsonTestCase(String name, String fileName, File directory, File baseDirFile) {
		super(name);
		_fileName = fileName;
		_fileDirectory = directory;
		_baseDirectory = baseDirFile;
	}

	@Override
	protected void setUp() {
		try {
			loadCalls();
			JSONObject loginResponse = performUSMAccess(-2,
					"{user:\"user3\", device:\"android\", password:\"secret\"}", "login");
			JSONObject logoutParams = new JSONObject();
			logoutParams.put("sessionid", loginResponse.getJSONObject("data").getString("sessionid"));
			logoutParams.put("endSynchronization", true);
			JSONObject logoutResponse = performUSMAccess(-1, logoutParams.toString(), "logout");
			assertEquals("Finalized logout during test setup failed", 1, logoutResponse.getInt("status"));
		} catch (Exception e) {
			e.printStackTrace();
			fail("Error while initializing test: " + e.getMessage());
		}
	}

	@Override
	protected void tearDown() throws Exception {
	}

	@Override
	public void runTest() throws Throwable {
		int i = 1;
		for (CallInfo callInfo : callList)
			executeJSONCall(i++, callInfo);
	}

	public void executeJSONCall(int n, CallInfo callInfo) throws Exception {
		if (WAIT.equals(callInfo._call)) {
			//wait 10 seconds
			long millis = 10000L;
			try {
				Thread.sleep(millis);
				return;
			} catch (InterruptedException e) {
				System.out.println("waiting " + millis / 1000 + " seconds..interrupted");
				return;
			}
		}

		String request = callInfo._callRequest;
		try {
			JSONObject requestBody = new JSONObject(request);
			_replacer.replaceAll(requestBody);
			request = requestBody.toString();
		} catch (JSONException e) {
			System.out.println(e);
		}
		JSONObject result = performUSMAccess(n, request, callInfo._call);
		if (result == null)
			fail("the response object is null");
		_replacer.compareAndExtract(n, callInfo._expectedResponse, result);;
	}

	private JSONObject performUSMAccess(int n, String requestBody, String call) throws Exception {
		PutMethod httppost = new PutMethod(USM_BASE_URL + call);
		httppost.setRequestEntity(new StringRequestEntity(requestBody, TEXT_JAVASCRIPT_CONTENTTYPE, CHARSET_UTF_8));
		httppost.setRequestHeader(new Header("Content-Type", TEXT_JAVASCRIPT_CONTENTTYPE));
		int statusCode = _httpclient.executeMethod(httppost);
		assertEquals("Call " + n + ": HTTP status code mismatch", 200, statusCode);
		String responseBodyAsString = httppost.getResponseBodyAsString();
		//System.out.println("RESPONCE:" + responseBodyAsString);
		return new JSONObject(responseBodyAsString);
	}

	private void loadCalls() throws JSONException {
		readCalls(_fileDirectory.getPath() + "/" + _fileName, 0);
	}

	private void readCalls(String name, int counter) throws JSONException {
		String call = null;
		String request = null;
		String line;
		BufferedReader reader = null;
		int linenumber = 0;
		try {
			File f = new File(name).getCanonicalFile();
			name = f.toString();
			reader = new BufferedReader(new FileReader(name));
			while ((line = reader.readLine()) != null) {
				linenumber++;
				if (!line.startsWith("#")) {
					counter++;
					if (counter == 1) {
						call = line;
						if (WAIT.equals(line)) {
							counter = 0;
							callList.add(new CallInfo(call, null, null));
						}
					} else if (counter == 2) {
						request = line;
					} else if (counter == 3) {
						callList.add(new CallInfo(call, request, new JSONObject(line)));
						counter = 0;
					}
				} else if (line.startsWith("#include ")) {
					readCalls(_baseDirectory.getPath() + "/" + "common/" + line.substring(9), counter);
				}
			}
		} catch (JSONException e) {
			fail("Invalid JSONObject at line " + linenumber);
		} catch (FileNotFoundException e) {
			fail("Could not load test file: " + name);
		} catch (IOException e) {
			fail("Could not load test file: " + name);
		} finally {
			if (reader != null) {
				try {
					reader.close();
				} catch (IOException ignored) {
				}
			}
		}
	}
}
