/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.test;

import java.util.*;

import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;

import org.json.*;

import com.openexchange.usm.util.JSONToolkit;

public class JSONTestReplacer {
	private static final String MARKER = "!!";
	private static final String INTEGER = "!!integer!!";
	private static final String UUID_KEY = "!!uuid!!";
	private static final String ANYTHING = "!!anything!!";
	private static final String NEW_UUID = "!!new:";

	private final Map<String, Object> _storedValues = new HashMap<String, Object>();

	public void replaceAll(JSONObject data) throws JSONException {
		for (String key : JSONToolkit.keys(data)) {
			Object v = data.opt(key);
			if (v instanceof String) {
				data.put(key, replaceValue((String) v));
			} else if (v instanceof JSONObject) {
				replaceAll((JSONObject) v);
			} else if (v instanceof JSONArray) {
				replaceAll((JSONArray) v);
			} else {
				// do nothing
			}
		}
	}

	public void replaceAll(JSONArray data) throws JSONException {
		int len = data.length();
		for (int i = 0; i < len; i++) {
			Object v = data.opt(i);
			if (v instanceof String) {
				data.put(i, replaceValue((String) v));
			} else if (v instanceof JSONObject) {
				replaceAll((JSONObject) v);
			} else if (v instanceof JSONArray) {
				replaceAll((JSONArray) v);
			} else {
				// do nothing
			}
		}
	}

	private Object replaceValue(String v) {
		if (!v.startsWith(MARKER) || !v.endsWith(MARKER))
			return v;
		Object o = _storedValues.get(v);
		if (o == null) {
			if (!v.startsWith(NEW_UUID))
				throw new AssertionFailedError("Pattern " + v + " was not retrieved in previous call");
			String realKey = MARKER + v.substring(NEW_UUID.length());
			if (_storedValues.containsKey(realKey))
				throw new AssertionFailedError("Pattern " + v + " was already generated in previous call");
			o = UUID.randomUUID().toString();
			_storedValues.put(realKey, o);
		}
		return o;
	}

	public void compareAndExtract(int n, JSONObject expectedResponse, JSONObject result) throws JSONException {
		doCompareAndExtract(expectedResponse, result);
		String s1 = expectedResponse.toString(2);
		String s2 = result.toString(2);
		if (!s1.equals(s2))
			throw new ComparisonFailure("Call " + n + ": Result mismatch", s1, s2);
	}

	private void doCompareAndExtract(JSONArray o1, JSONArray o2) {
		int len = o1.length();
		for (int i = 0; i < len; i++) {
			Object v = o1.opt(i);
			if (v instanceof String) {
				String s = (String) v;
				if (s.equals(INTEGER)) {
					if (o2 != null) {
						try {
							o1.put(i, o2.getLong(i));
						} catch (JSONException e) {
						}
					}
				} else if (s.equals(UUID_KEY)) {
					if (o2 != null) {
						try {
							String sv = o2.getString(i);
							UUID.fromString(sv);
							o1.put(i, sv);
						} catch (IllegalArgumentException e) {
						} catch (JSONException e) {
						}
					}
				} else if (s.equals(ANYTHING)) {
					if (o2 != null) {
						try {
							o1.put(i, o2.get(i));
						} catch (JSONException e) {
						}
					}
				} else if (s.startsWith(MARKER) && s.endsWith(MARKER)) {
					Object o = _storedValues.get(s);
					try {
						if (o != null)
							o1.put(i, o);
						else {
							if (o2 != null) {
								o = o2.get(i);
								o1.put(i, o);
								_storedValues.put(s, o);
							}
						}
					} catch (JSONException e) {
					}
				}
			} else if (v instanceof JSONObject) {
				if (o2 != null)
					doCompareAndExtract((JSONObject) v, o2.optJSONObject(i));
			} else if (v instanceof JSONArray) {
				if (o2 != null)
					doCompareAndExtract((JSONArray) v, o2.optJSONArray(i));
			} else {
				// do nothing
			}
		}
	}

	private void doCompareAndExtract(JSONObject o1, JSONObject o2) {
		//see if in the expected result some keys need to be replaced
		JSONArray keys = new JSONArray();
		for (String key : JSONToolkit.keys(o1)) {
			keys.put(key);
		}
		try {
		for (int i = 0; i < keys.length(); i++) {
			String key = keys.getString(i);
			if(_storedValues.containsKey(key)) {
				Object value = o1.get(key);
				String newKey = (String) _storedValues.get(key);
				o1.remove(key);
				o1.put(newKey, value);
			}
		}
		}catch (JSONException e) {
			
		}
		//do the replace
		for (String key : JSONToolkit.keys(o1)) {
			Object v = o1.opt(key);
			if (v instanceof String) {
				String s = (String) v;
				if (s.equals(INTEGER)) {
					if (o2 != null) {
						try {
							o1.put(key, o2.getLong(key));
						} catch (JSONException e) {
						}
					}
				} else if (s.equals(UUID_KEY)) {
					if (o2 != null) {
						try {
							String sv = o2.getString(key);
							UUID.fromString(sv);
							o1.put(key, sv);
						} catch (IllegalArgumentException e) {
						} catch (JSONException e) {
						}
					}
				} else if (s.equals(ANYTHING)) {
					if (o2 != null) {
						try {
							o1.put(key, o2.get(key));
						} catch (JSONException e) {
						}
					}
				} else if (s.startsWith(MARKER) && s.endsWith(MARKER)) {
					Object o = _storedValues.get(s);
					try {
						if (o != null)
							o1.put(key, o);
						else {
							if (o2 != null) {
								o = o2.get(key);
								o1.put(key, o);
								_storedValues.put(s, o);
							}
						}
					} catch (JSONException e) {
					}
				}
			} else if (v instanceof JSONObject) {
				if (o2 != null)
					doCompareAndExtract((JSONObject) v, o2.optJSONObject(key));
			} else if (v instanceof JSONArray) {
				if (o2 != null)
					doCompareAndExtract((JSONArray) v, o2.optJSONArray(key));
			} else {
				// do nothing
			}
		}
	}
}
