/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.connector.test;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.json.JSONObject;

import com.openexchange.usm.json.ServletConstants;


public class TestClient {

	
	public final static String USER = "user";
	public final static String DEVICE = "device";
	public final static String PASSWORD = "password";
	public final static String RETURN_CONFIG = "returnConfiguration";

	/**
	 * @param args
	 */

	public final static void main(String[] args) throws Exception {

		HttpClient httpclient = new HttpClient();
		
		PutMethod httppost = new PutMethod("http://localhost:8080/ConnectorServlet/usm/login");
		JSONObject requestBody = new JSONObject();
		requestBody.put(USER, "user2");
		requestBody.put(DEVICE, "android");
		requestBody.put(PASSWORD, "secret");
		requestBody.put(RETURN_CONFIG, Boolean.TRUE);
		
		httppost.setRequestEntity(new StringRequestEntity(requestBody.toString(), ServletConstants.TEXT_JAVASCRIPT, ServletConstants.UTF_ENCODING_8));

		httppost.setRequestHeader(new Header("Content-Type", ServletConstants.TEXT_JAVASCRIPT));
		
   
		System.out.println("executing request " + httppost.getURI());
		
		int statusCode = httpclient.executeMethod(httppost);
		System.out.println("HTTP statusCode= " + statusCode);
		String data = httppost.getResponseBodyAsString();
		System.out.println(data);
		System.out.println("Login command end----------------------------------------");
		
		JSONObject loginResponseObject = new JSONObject(data);
		String sessionID = ((JSONObject)loginResponseObject.get("data")).getString("sessionid");

		
		httppost = new PutMethod("http://localhost:8080/ConnectorServlet/usm/logout");
		requestBody = new JSONObject();
		requestBody.put("sessionid", sessionID);
		requestBody.put("endSynchronization", true);
		
		httppost.setRequestEntity(new StringRequestEntity(requestBody.toString(), ServletConstants.TEXT_JAVASCRIPT, ServletConstants.UTF_ENCODING_8));

		httppost.setRequestHeader(new Header("Content-Type", ServletConstants.TEXT_JAVASCRIPT));
		
   
		System.out.println("executing request " + httppost.getURI());
		
		statusCode = httpclient.executeMethod(httppost);
		System.out.println("HTTP statusCode= " + statusCode);
		data = httppost.getResponseBodyAsString();
		System.out.println(data);
		System.out.println("Logout command end----------------------------------------");
		
	}
}
