/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json;

import javax.servlet.http.HttpSession;

import org.json.JSONObject;

import com.openexchange.usm.connector.commands.*;
import com.openexchange.usm.json.response.ResponseStatusCode;

/**
 * Creates delegate instance for certain USM-JSON command. 
 * @author ldo
 *
 */
public class CommandDelegateFactory {

	public static CommandHandler createCommandHandler(USMJSONServlet servlet, HttpSession httpSession,
			String command, JSONObject parameters) throws USMJSONAPIException {
		if (ServletConstants.USM_LOGIN.equals(command))
			return new LoginHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_LOGOUT.equals(command))
			return new LogoutHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_LOGOUT.equals(command))
			return new LogoutHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_GET_CONFIGURATION.equals(command))
			return new GetConfigurationHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_SET_CONFIGURATION.equals(command))
			return new SetConfigurationHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_MOVE_ITEMS.equals(command))
			return new MoveItemsHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_READ_DATA.equals(command))
			return new ReadDataHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_RESOLVE_RECIPIENTS.equals(command))
			return new ResolveRecipientsHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_SEND_MAIL.equals(command))
			return new SendMailHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_SET_PUSH_NOTIFICATION.equals(command))
			return new SetPushNotificationHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_SYNC_ESTIMATE.equals(command))
			return new SyncEstimateHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_SYNC_INIT.equals(command))
			return new SyncInitHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_SYNC_UPDATE.equals(command))
			return new SyncUpdateHandler(servlet, httpSession, parameters);
		if (ServletConstants.GET_CACHED_DATA.equals(command))
			return new GetCachedDataHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_PING.equals(command))
			return new PingHandler(servlet, httpSession, parameters);
		if (ServletConstants.USM_RESOLVE_IDS.equals(command))
			return new ResolveIDsHandler(servlet, httpSession, parameters);
		throw new USMJSONAPIException(ConnectorBundleErrorCodes.BAD_COMMAND_IN_REQUEST, ResponseStatusCode.BAD_REQUEST,
				"Unknown command " + command);
	}
}
