/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.connector.commands;

import static com.openexchange.usm.connector.commands.CommandConstants.*;

import java.util.Arrays;

import javax.servlet.http.HttpSession;

import org.json.JSONObject;

import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.*;
import com.openexchange.usm.json.*;
import com.openexchange.usm.json.response.ResponseObject;
import com.openexchange.usm.json.response.ResponseStatusCode;
import com.openexchange.usm.session.dataobject.DataObjectSet;
import com.openexchange.usm.session.dataobject.FolderHierarchyComparator;

/**
 * Handler for the SyncInit USM-JSON-Command.
 * @author afe
 *
 */
public class SyncInitHandler extends SyncCommandHandler {
	private final static String[] REQUIRED_PARAMETERS = { SESSIONID };
	private final static String[] OPTIONAL_PARAMETERS = { FOLDERID, CREATED, LIMIT, CONFLICT_RESOLUTION };

	public SyncInitHandler(USMJSONServlet servlet, HttpSession httpSession, JSONObject parameters)
			throws USMJSONAPIException {
		super(servlet, httpSession, parameters);
	}

	@Override
	public ResponseObject handleRequest() throws USMJSONAPIException {
		String folderUUID = getStringParameter(FOLDERID, null);
		int limit = getOptionalLimit();
		ConflictResolution conflictResolution = getOptionalConflictResolution();
		SyncResult result = computeSyncInit(folderUUID, limit, conflictResolution);
		Folder folder = null;
		if (folderUUID != null)
			folder = getFolderByUUID(folderUUID);
		_cachedElements = new DataObjectSet(result.getNewState());
		long syncId = makeDelayedCallsAndSaveNewState(limit, result, folder, result.getTimestamp());
		JSONObject response = createResponseFromSyncResults(result, syncId);
		return new ResponseObject(ResponseStatusCode.SUCCESS, response);
	}

	private SyncResult computeSyncInit(String folderID, int limit, ConflictResolution conflictResolution)
			throws USMJSONAPIException {
		try {
			if (folderID == null) {
				Folder[] clientFolders = readCreatedFolders(null);
				_allFolders = clientFolders;
				Arrays.sort(clientFolders, new FolderHierarchyComparator(clientFolders));
				return _session.syncFoldersWithServer(limit, null, true, conflictResolution, clientFolders);
			}
			Folder folder = getFolderByUUID(folderID);
			_clientChangesArray = readCreatedFolderElements(folder, -1L, conflictResolution);
			addModificationsForExceptions(new DataObject[0], new DataObject[0], _clientChangesArray); //create appointment exceptions in delayed calls
			return _session.syncWithServer(folder.getID(), limit, null, true, conflictResolution, _clientChangesArray);
		} catch (USMJSONAPIException e) {
			throw e;
		} catch (SlowSyncRequiredException e) {
			throw new USMJSONAPIException(ConnectorBundleErrorCodes.SYNC_INIT_INVALID_SYNCID,
					ResponseStatusCode.UNKNOWN_SYNCID, "Unknown SyncID");
		} catch (SynchronizationConflictException e) {
			throw generateConflictException(e);
		} catch (USMException e) {
			throw USMJSONAPIException.createInternalError(ConnectorBundleErrorCodes.SYNC_INIT_INTERNAL_ERROR, e);
		}
	}

	@Override
	protected String[] getOptionalParameters() {
		return OPTIONAL_PARAMETERS;
	}

	@Override
	protected String[] getRequiredParameters() {
		return REQUIRED_PARAMETERS;
	}

	@Override
	protected long getOriginalSyncID() {
		return 0L;
	}
}
