/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.connector.commands;

import static com.openexchange.usm.connector.commands.CommandConstants.*;

import java.util.UUID;

import javax.servlet.http.HttpSession;

import org.json.*;

import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.json.*;
import com.openexchange.usm.json.response.ResponseObject;
import com.openexchange.usm.json.response.ResponseStatusCode;
import com.openexchange.usm.session.dataobject.DataObjectSet;

/**
 * Handler for the USM-Retrieve OX Ids command.
 * 
 * @author ldo
 *
 */
public class ResolveIDsHandler extends BaseCommandHandler {

	private static final String NOT_FOUND = "Not Found";
	private final static String[] REQUIRED_PARAMETERS = { USER, DEVICE, PASSWORD, OBJECT_UUIDS };
	private final static String[] OPTIONAL_PARAMETERS = { FOLDER_UUID };

	public ResolveIDsHandler(USMJSONServlet servlet, HttpSession httpSession, JSONObject parameters)
			throws USMJSONAPIException {
		super(servlet, httpSession, parameters);
	}

	@Override
	public ResponseObject handleRequest() throws USMJSONAPIException {
		try {
			_session = _servlet.getSession(getStringParameter(USER), getStringParameter(PASSWORD),
					getStringParameter(DEVICE));
			String folderUUID = getStringParameter(FOLDER_UUID);
			JSONArray objectUUIDs = getJSONArray(_parameters, OBJECT_UUIDS);
			JSONObject resultData = new JSONObject();
			JSONObject objectIds = new JSONObject();
			DataObject[] cachedObjects = null;
			if (folderUUID != null) {
				Folder folder = null;
				try {
					folder = getFolderByUUID(folderUUID);
				} catch (USMJSONAPIException e1) {
					//do nothing
				}
				resultData.put(FOLDER_ID, folder != null ? folder.getID() : NOT_FOUND);
				if (folder != null)
					cachedObjects = _session.getCachedFolderElements(folder.getID(), folder.getElementsContentType());
			} else {
				cachedObjects = _session.getCachedFolders();
			}

			DataObjectSet objectSet = new DataObjectSet(cachedObjects);
			for (int i = 0; i < objectUUIDs.length(); i++) {
				String uuid = objectUUIDs.getString(i);
				DataObject object = objectSet.get(UUID.fromString(uuid));
				objectIds.put(uuid, object != null ? object.getID() : NOT_FOUND);
			}
			resultData.put(OBJECTIDS, objectIds);
			return new ResponseObject(ResponseStatusCode.SUCCESS, resultData);
		} catch (IllegalArgumentException e) {
			throw new USMJSONAPIException(ConnectorBundleErrorCodes.RESOLVE_IDS_INVALID_UUID,
					ResponseStatusCode.WRONG_MISSING_PARAMETERS, "Invalid UUID", e);
		} catch (USMException e) {
			throw new USMJSONAPIException(ConnectorBundleErrorCodes.RESOLVE_IDS_LOGIN_UNSUCCESSFUL,
					ResponseStatusCode.ACCESS_DENIED, "Can not login.", e);
		} catch (JSONException e) {
			throw USMJSONAPIException.createJSONError(
					ConnectorBundleErrorCodes.RESOLVE_IDS_JSON_ERROR_ON_CREATE_RESULT, e);
		}
	}

	@Override
	protected String[] getOptionalParameters() {
		return OPTIONAL_PARAMETERS;
	}

	@Override
	protected String[] getRequiredParameters() {
		return REQUIRED_PARAMETERS;
	}

}
