/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.connector.commands;

import static com.openexchange.usm.connector.commands.CommandConstants.*;

import java.util.*;

import javax.servlet.http.HttpSession;

import org.json.*;

import com.openexchange.usm.api.contenttypes.*;
import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.datatypes.*;
import com.openexchange.usm.api.exceptions.*;
import com.openexchange.usm.api.session.*;
import com.openexchange.usm.datatypes.contacts.ContactDistributionMember;
import com.openexchange.usm.datatypes.contacts.Image;
import com.openexchange.usm.json.*;
import com.openexchange.usm.json.response.ResponseStatusCode;
import com.openexchange.usm.session.dataobject.DataObjectUtil;
import com.openexchange.usm.util.Toolkit;

public abstract class NormalCommandHandler extends BaseCommandHandler {

	protected DataObject[] _allFolders;

	public NormalCommandHandler(USMJSONServlet servlet, HttpSession httpSession, JSONObject parameters)
			throws USMJSONAPIException {
		super(servlet, httpSession, parameters);
		String sessionID = getStringParameter(SESSIONID);
		USMSessionID usmSessionID = (USMSessionID) httpSession.getAttribute(sessionID);
		if (usmSessionID == null)
			throw new USMJSONAPIException(ConnectorBundleErrorCodes.COMMAND_UNKNOWN_SESSION,
					ResponseStatusCode.UNKNOWN_SESSION, "Unknown " + SESSIONID);
		try {
			setSession(servlet.getSession(usmSessionID.getUser(), usmSessionID.getPassword(), usmSessionID.getDevice()));
		} catch (USMAccessDeniedException e) {
			throw new USMJSONAPIException(ConnectorBundleErrorCodes.COMMAND_ACCESS_DENIED,
					ResponseStatusCode.ACCESS_DENIED, e.getErrorMessage());
		} catch (USMException e) {
			throw USMJSONAPIException.createInternalError(ConnectorBundleErrorCodes.COMMAND_INTERNAL_ERROR, e);
		}
	}

	

	protected FolderContentType getFolderContentType() {
		return (FolderContentType) _servlet.getContentTypeManager().getContentType(DefaultContentTypes.FOLDER_ID);
	}

	

	protected void storeExtraFields(ContentType type, BitSet extraFields) throws DatabaseAccessException,
			USMSQLException {
		JSONSessionInitializer.storeExtraFields(_session, type, extraFields);
	}

	protected JSONObject storeCompleteDataObjectInJSONObject(DataObject o) throws JSONException, USMJSONAPIException {
		return storeCompleteDataObjectInJSONObject(o, null);
	}

	protected JSONObject storeCompleteDataObjectInJSONObject(DataObject o,
			Map<DataObject, List<DataObject>> exceptionsMap) throws JSONException, USMJSONAPIException {
		JSONObject newObject = storeDataObjectFieldsInJSONObject(o);
		if (exceptionsMap != null && !exceptionsMap.isEmpty()) {
			for (Map.Entry<DataObject, List<DataObject>> entry : exceptionsMap.entrySet()) {
				DataObject object = entry.getKey();
				if (object.getID().equals(o.getID()))
					storeExceptionsInJSONObject(newObject, entry.getValue());
			}
		}
		newObject.put(OBJECT_TYPE, o.getContentType().getID());
		newObject.put(UUID_KEY, o.getUUID().toString());
		return newObject;
	}

	private void storeExceptionsInJSONObject(JSONObject jo, List<DataObject> exceptions) throws USMJSONAPIException,
			JSONException {
		JSONArray exceptionsJSONArray = new JSONArray();
		for (DataObject dataObject : exceptions) {
			JSONObject exceptionJSONObject = storeCompleteDataObjectInJSONObject(dataObject);
			exceptionsJSONArray.put(exceptionJSONObject);
		}
		jo.put(CHANGE_EXCEPTIONS, exceptionsJSONArray);
	}

	protected JSONObject storeDataObjectFieldsInJSONObject(DataObject o) throws JSONException, USMJSONAPIException {
		JSONObject newObject = new JSONObject();
		ContentTypeField[] fields = o.getContentType().getFields();
		for (int i = 0; i < fields.length; i++) {
			DataType<?> fieldType = fields[i].getFieldType();
			Object v = o.getFieldContent(i);
			if (o.getChangeState() != ChangeState.MODIFIED ? !fieldType.isDefaultValue(v) : o.isFieldModified(i)) {
				if (IMAGE1.equals(fieldType.getName())) {
					if (v == null) {
						newObject.put(IMAGE1, JSONObject.NULL);
					} else {
						byte[] data = ((Image) v).getData();
						newObject.put(IMAGE1, data == null ? JSONObject.NULL : Toolkit.encodeBase64(data));
					}
				} else if (ATTACHMENTS_LAST_MODIFIED.equals(fields[i].getFieldName())) {
					storeAttachmentsInJSONObject(o.getSession(), newObject, v,
							convertToPIMAttachmentDataType(fieldType), o);
				} else if (NUMBER_OF_ATTACHMENTS.equals(fields[i].getFieldName())) {
					fieldType.storeInJSONObject(o.getSession(), newObject, fields[i].getFieldName(), v);
					if (!o.isFieldModified(ATTACHMENTS_LAST_MODIFIED)) {
						for (int j = 0; j < fields.length; j++) {
							if (ATTACHMENTS_LAST_MODIFIED.equals(fields[j].getFieldName())) {
								fieldType = fields[j].getFieldType();
								v = o.getFieldContent(j);
								storeAttachmentsInJSONObject(o.getSession(), newObject, v,
										convertToPIMAttachmentDataType(fieldType), o);
							}
						}
					}
				} else if (CommandConstants.DISTRIBUTION_LIST.equals(fields[i].getFieldName())) {
					fieldType.storeInJSONObject(o.getSession(), newObject, fields[i].getFieldName(), v);
					JSONArray list = newObject.getJSONArray(CommandConstants.DISTRIBUTION_LIST);
					JSONArray newList = new JSONArray();
					for (int j = 0; j < list.length(); j++) {
						ContactDistributionMember dMember = new ContactDistributionMember(list.getJSONObject(j));
						JSONObject jObj = dMember.toJSONObject();
						String user_id = dMember.getUser_id();
						if (user_id != null) {
							try {
								UUID uuid = o.getSession().getUUID(o.getContentType(), Integer.parseInt(user_id));
								if (uuid != null)
									jObj.put(UUID_KEY, uuid.toString());
							} catch (NumberFormatException e) {
								//do nothing
							} catch (USMException e) {
								//do nothing
							}
						}
						newList.put(jObj);
					}
					newObject.put(CommandConstants.DISTRIBUTION_LIST, newList);
				} else { //if (!CHANGE_EXCEPTIONS.equals(fields[i].getFieldName())) {
					fieldType.storeInJSONObject(o.getSession(), newObject, fields[i].getFieldName(), v);
				}
			}
		}
		if (o.getContentType().getID().equals(DefaultContentTypes.FOLDER_ID)) {
			addOptionalFolderUUID(o, newObject);
		}
		return newObject;
	}

	protected void addOptionalFolderUUID(DataObject o, JSONObject object) throws USMJSONAPIException, JSONException {
		if (object.has(FOLDER_ID)) {
			if (_allFolders == null) {
				try {
					_allFolders = _session.getCachedFolders();
				} catch (DatabaseAccessException e) {
					throw generateCantDetermineFolderIDException();
				} catch (USMSQLException e) {
					throw generateCantDetermineFolderIDException();
				}
			}
			DataObject parent = DataObjectUtil.findDataObject(o.getParentFolderID(), _allFolders);
			object.put(FOLDER_UUID, (parent != null) ? parent.getUUID().toString() : "");
		}
	}

	@SuppressWarnings("unchecked")
	private DataType<PIMAttachments> convertToPIMAttachmentDataType(DataType<?> fieldType) {
		return (DataType<PIMAttachments>) fieldType;
	}

	private USMJSONAPIException generateCantDetermineFolderIDException() throws USMJSONAPIException {
		return new USMJSONAPIException(ConnectorBundleErrorCodes.COMMAND_CANNOT_DETERMINE_FOLDER_UUID,
				ResponseStatusCode.INTERNAL_ERROR, "Can not determine folder_uuid, list of folders not available");
	}

	private void storeAttachmentsInJSONObject(Session session, JSONObject jObj, Object value,
			DataType<PIMAttachments> fieldType, DataObject dataObject) throws JSONException {
		PIMAttachments attachments = fieldType.checkValue(value);
		if (attachments == null) //  || attachments.size() == 0
			return;
		JSONArray array = new JSONArray();
		for (int i = 0; i < attachments.size(); i++) {
			PIMAttachment att = attachments.getAttachment(i);
			JSONObject object = att.toJSONObject();
			object.put(UUID_KEY, att.getUUID().toString());
			object.put(CommandConstants.DATA_KEY, Toolkit.encodeBase64(att.getData()));
			array.put(object);
		}
		if (array.length() >= 0)
			jObj.put(ATTACHMENTS, array);
	}
}
