/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.database.ox;

import java.sql.*;

import org.apache.commons.logging.Log;
import org.osgi.service.component.ComponentContext;

import com.openexchange.database.CreateTableService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.groupware.AbstractOXException;
import com.openexchange.usm.api.database.DatabaseAccess;
import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.exceptions.USMSQLException;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.util.Toolkit;

public class CreateUSMTablesService implements CreateTableService {
	private final static String[] REQUIRED_TABLES = {};

	private Log _journal;

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void activate(ComponentContext context) {
		Journal journal = (Journal) context.locateService(Journal.class.getName());
		_journal = journal.getLog(DatabaseAccess.class);
		_journal.info("CreateTableService 'CreateUSMTablesService' activated");
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void deactivate(ComponentContext context) {
		_journal.info("CreateTableService 'CreateUSMTablesService' deactivated");
		_journal = null;
	}

	public void perform(Connection con) throws AbstractOXException {
		_journal.debug("Performing CreateTableService 'CreateUSMTablesService'");
		Statement stmt = null;
		try {
			stmt = con.createStatement();
			for (int i = 0; i < TableDefinition.SQL_STATEMENTS.length; i++) {
				stmt.execute(TableDefinition.SQL_STATEMENTS[i]);
			}
			for (int i = 0; i < TableDefinition.UUID_SQL_STATEMENTS.length; i++) {
				stmt.execute(TableDefinition.UUID_SQL_STATEMENTS[i]);
			}
			for (int i = 0; i < TableDefinition.SEQUENCE_TABLES_NAMES.length; i++) {
				TableDefinition.generateSequence(TableDefinition.SEQUENCE_TABLES_NAMES[i], con, _journal, false, true);
			}
			_journal.info("CreateTableService 'CreateUSMTablesService' successfully performed!");
		} catch (SQLException e) {
			DBPoolingExceptionCodes.SQL_ERROR.create(e, e.getMessage());
		} catch (USMSQLException e) {
			DBPoolingExceptionCodes.SQL_ERROR.create(e, e.getMessage());
		} catch (DatabaseAccessException e) {
			DBPoolingExceptionCodes.SQL_ERROR.create(e, e.getMessage());
		} finally {
			Toolkit.close(stmt);
		}
	}

	public String[] requiredTables() {
		return REQUIRED_TABLES;
	}

	public String[] tablesToCreate() {
		String[] tablesToCreate = new String[TableDefinition.TABLE_NAMES.length
				+ TableDefinition.SEQUENCE_TABLES_NAMES.length];
		int i = 0;
		for (String table : TableDefinition.TABLE_NAMES) {
			tablesToCreate[i] = table;
			i++;
		}
		for (String table : TableDefinition.SEQUENCE_TABLES_NAMES) {
			tablesToCreate[i] = table;
			i++;
		}
		return tablesToCreate;
	}
}
