/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.resources.impl;

import static com.openexchange.usm.api.datatypes.DataTypes.NUMBER;
import static com.openexchange.usm.api.datatypes.DataTypes.STRING;

import com.openexchange.usm.api.contenttypes.ContentTypeField;
import com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler;
import com.openexchange.usm.api.contenttypes.DefaultContentTypes;
import com.openexchange.usm.api.contenttypes.ResourceContentType;
import com.openexchange.usm.api.datatypes.PIMAttachment;
import com.openexchange.usm.api.datatypes.PIMAttachments;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.contenttypes.util.AbstractContentType;
import com.openexchange.usm.contenttypes.util.UtilConstants;

public class ResourcesContentTypeImpl extends AbstractContentType implements ResourceContentType {

	private final static ContentTypeField[] FIELDS = {
			new ContentTypeField(-1900, UtilConstants.FIELD_ID, NUMBER, false, true, false, false), //ID 
			new ContentTypeField(-1901, UtilConstants.FOLDER_ID, STRING, false, false, true, false), //Object ID of the parent folder. Dummy field. Always empty
			new ContentTypeField(-1902, ResourcesConstants.DISPLAY_NAME, STRING) //Display Name 
	};

	private ResourcesContentTypeTransferHandler _transferHandler;

	public long createNewAttachment(DataObject object, PIMAttachment attachment) throws USMException {
		return 0;
	}

	public long deleteAttachments(DataObject object, PIMAttachment... attachmentsToDelete) throws USMException {
		return 0;
	}

	public PIMAttachments getAllAttachments(DataObject object, String sort, String order) throws USMException {
		return null;
	}

	public PIMAttachments getAllAttachments(DataObject object) throws USMException {
		return null;
	}

	public byte[] getAttachmentData(DataObject object, int attachmentId) throws USMException {
		return null;
	}

	public int getCode() {
		return DefaultContentTypes.RESOURCES_CODE;
	}

	public ContentTypeField[] getFields() {
		return FIELDS;
	}

	public String getID() {
		return DefaultContentTypes.RESOURCES_ID;
	}

	public Object getObjectGroupOwner(DataObject object) {
		return object.getID();
	}

	public ContentTypeTransferHandler getTransferHandler() {
		return _transferHandler;
	}
	
	public void setTransferHandler(ResourcesContentTypeTransferHandler transferHandler) {
		_transferHandler = transferHandler;
	}

	public boolean supportsPIMAttachments() {
		return false;
	}
	
	@Override
	public int hashCode() {
		return 201731;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof ResourceContentType))
			return false;
		return true;
	}
	
	@Override
	public boolean canBeFolderElementsContentType() {
		return false;
	}

}
