/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.datatypes.mail;

import java.io.Serializable;
import java.util.*;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.usm.api.contenttypes.ContentTypeField;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.contenttypes.mail.impl.MailContentTypeImpl;

public class NestedMail implements Serializable {

	private final static String FILENAME = "filename";
	private final static String ID = "id";
	private final static String FOLDER_ID = "folder_id";
	private final static String ATTACHMENT = "attachment";

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final Map<String, Object> _map;

	public NestedMail(Session session, JSONObject jSONObject) throws JSONException {
		HashMap<String, Object> map = new HashMap<String, Object>();
		ContentTypeField[] fields = MailContentTypeImpl.getAllFields();
		for (int i = 0; i < fields.length; i++) {
			ContentTypeField field = fields[i];
			String fieldName = field.getFieldName();
			if (!isSpecialField(fieldName) && jSONObject.has(fieldName))
				map.put(field.getFieldName(), field.getFieldType()
						.extractFromJSONObject(session, jSONObject, fieldName));
		}
		if (jSONObject.has(FILENAME))
			map.put(FILENAME, jSONObject.getString(FILENAME));
		_map = Collections.unmodifiableMap(map);
	}

	public NestedMail(Map<String, Object> map, boolean flag) {
		HashMap<String, Object> m = new HashMap<String, Object>();
		ContentTypeField[] fields = MailContentTypeImpl.getAllFields();
		for (int i = 0; i < fields.length; i++) {
			String fieldName = fields[i].getFieldName();
			if (!isSpecialField(fieldName) && map.containsKey(fieldName))
				m.put(fieldName, map.get(fieldName));
		}
		if (map.containsKey(FILENAME))
			m.put(FILENAME, map.get(FILENAME));
		_map = Collections.unmodifiableMap(m);
	}

	public NestedMail(ArrayList<Object> list) {
		HashMap<String, Object> map = new HashMap<String, Object>();
		ContentTypeField[] fields = MailContentTypeImpl.getAllFields();
		for (int i = 0; i < fields.length; i++) {
			ContentTypeField field = fields[i];
			String fieldName = field.getFieldName();
			if (i < list.size() && !isSpecialField(fieldName)) {
				Object v = list.get(i);
				if (!field.getFieldType().isDefaultValue(v))
					map.put(fieldName, list.get(i));
			}
		}
		_map = Collections.unmodifiableMap(map);
	}
	
	public NestedMail() {
		_map = Collections.emptyMap();
	}

	private boolean isSpecialField(String fieldName) {
		return ID.equals(fieldName) || FOLDER_ID.equals(fieldName) || ATTACHMENT.equals(fieldName);
	}

	public Map<String, Object> getMap() {
		return _map;
	}

	@Override
	public int hashCode() {
		return _map.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		NestedMail other = (NestedMail) obj;

		return _map.equals(other.getMap());
	}

	public JSONObject toJSONObject(Session session) throws JSONException {
		JSONObject o = new JSONObject();
		Object v = _map.get(FILENAME);
		if (v != null)
			o.put(FILENAME, v);
		ContentTypeField[] fields = MailContentTypeImpl.getAllFields();
		for (int i = 0; i < fields.length; i++) {
			ContentTypeField field = fields[i];
			String fieldName = field.getFieldName();
			v = _map.get(fieldName);
			if (v != null)
				field.getFieldType().storeInJSONObject(session, o, fieldName, v);
		}
		return o;
	}
}
