/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.datatypes.mail;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author ibr
 *
 *    Name 	        Type 	 Value
      id 	        String 	 Object ID (unique only inside the same message)
      content_type 	String 	 MIME type
      content 	    String 	 Content as text. Present only if easily convertible to text.
      filename 	    String 	 Displayed filename (mutually exclusive with content).
      size 	        Number 	 Size of the attachment in bytes.
      disp 	        String 	 Attachment's disposition: null, inline, attachment or alternative. 
 */
public class MailAttachment implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	final public static String OBJECTID = "id";
	final public static String CONTENTTYPE = "content_type";
	final public static String CONTENT = "content";
	final public static String FILENAME = "filename";
	final public static String SIZE = "size";
	final public static String DISP = "disp";

	//Object ID (unique only inside the same message) 
	final private String _id;
	//MIME type
	final private String _content_type;
	//Content as text. Present only if easily convertible to text. 
	final private String _content;
	//Displayed filename (mutually exclusive with content). 
	final private String _filename;
	//Size of the attachment in bytes. 
	final private int _size;
	//Attachment's disposition: null, inline, attachment or alternative. 
	final private String _disp;

	public MailAttachment(String id, String content_type, String content, String filename, int size, String disp) {
		_id = id;
		_content_type = content_type;
		_content = content;
		_filename = filename;
		_size = size;
		_disp = disp;
	}
	
	public MailAttachment() {
		_id = "";
		_content_type = "";
		_content = "";
		_filename = "";
		_size = 0;
		_disp = "";
	}

	public MailAttachment(JSONObject jSONObject) throws JSONException {
		if (jSONObject.has(OBJECTID))
			_id = jSONObject.getString(OBJECTID);
		else
			_id = null;
		if (jSONObject.has(CONTENTTYPE))
			_content_type = jSONObject.getString(CONTENTTYPE);
		else
			_content_type = "";
		if (jSONObject.has(CONTENT))
			_content = jSONObject.getString(CONTENT);
		else
			_content = "";
		if (jSONObject.has(FILENAME))
			_filename = jSONObject.getString(FILENAME);
		else
			_filename = "";
		if (jSONObject.has(SIZE))
			_size = jSONObject.getInt(SIZE);
		else
			_size = -1;
		if (jSONObject.has(DISP))
			_disp = jSONObject.getString(DISP);
		else
			_disp = "";
	}

	public String getId() {
		return _id;
	}

	public String getContent_type() {
		return _content_type;
	}
	

	public String getContent() {
		return _content;
	}

	public String getFilename() {
		return _filename;
	}

	public int getSize() {
		return _size;
	}

	public String getDisp() {
		return _disp;
	}

	@Override
	public int hashCode() {
		final int prime = 37;
		int result = 1;
		result = prime * result + _id.hashCode();
		result = prime * result + _content_type.hashCode();
		result = prime * result + _content.hashCode();
		result = prime * result + _filename.hashCode();
		result = prime * result + _size;
		result = prime * result + _disp.hashCode();
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		MailAttachment other = (MailAttachment) obj;
		if (!_id.equals(other._id))
			return false;
		if (!_content_type.equals(other._content_type))
			return false;
		if (!_content.equals(other._content))
			return false;
		if (!_filename.equals(other._filename))
			return false;
		if (_size != other._size)
			return false;
		if (!_disp.equals(other._disp))
			return false;
		return true;
	}

	
	@Override
	public String toString() {
		return '{' + OBJECTID + ':' + _id + ';' + CONTENTTYPE + ':' + _content_type + ';' + CONTENT + ':' + _content
				+ ';' + FILENAME + ':' + _filename + ';' + SIZE + ':' + _size + ';' + DISP + ':' + _disp + '}';
	}

	public JSONObject toJSONObject() throws JSONException {
		JSONObject js = new JSONObject();
		js.put(OBJECTID, _id);
		js.put(CONTENTTYPE, _content_type);
		js.put(CONTENT, _content);
		js.put(FILENAME, _filename);
		js.put(SIZE, _size);
		js.put(DISP, _disp);
		return js;
	}
}