/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.mail.impl;

import java.util.BitSet;

import org.json.JSONObject;
import org.osgi.service.component.ComponentContext;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.contenttypes.MailContentType;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.contenttypes.util.AbstractContentTypeService;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.ox_json.OXJSONAccess;

public class MailContentTypeService extends AbstractContentTypeService implements MailContentType {

	private final MailContentTypeImpl _mailContentType = new MailContentTypeImpl();

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void activate(ComponentContext context) {
		OXJSONAccess ajaxAccess = (OXJSONAccess) context.locateService(OXJSONAccess.class.getName());
		Journal journal = (Journal) context.locateService(Journal.class.getName());
		MailContentTypeTransferHandlerImpl transferHandler = new MailContentTypeTransferHandlerImpl(_mailContentType,
				journal.getLog(MailContentTypeTransferHandlerImpl.class), ajaxAccess);
		_mailContentType.setTransferHandler(transferHandler);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void deactivate(ComponentContext context) {
		_mailContentType.setTransferHandler(null);
	}

	public DataObject getReplyForward(Session session, String messageID, String folderID, String action)
			throws USMException {
		return _mailContentType.getReplyForward(session, messageID, folderID, action);
	}

	public byte[] readMailSource(DataObject object, BitSet requestedFields) throws USMException {
		return _mailContentType.readMailSource(object, requestedFields);
	}

	public void sendMail(String mail, Session session) throws USMException {
		_mailContentType.sendMail(mail, session);
	}

	public String createNewMail(String folderId, int flag, String mailMIMEdataBlock, Session session)
			throws USMException {
		return _mailContentType.createNewMail(folderId, flag, mailMIMEdataBlock, session);
	}

	public Object getMailAttachment(Session session, String folderId, String mailId, String attachmentId)
			throws USMException {
		return _mailContentType.getMailAttachment(session, folderId, mailId, attachmentId);
	}

	public JSONObject readStructuredMail(DataObject object, BitSet requestedFields) throws USMException {
		return _mailContentType.readStructuredMail(object, requestedFields);
	}

	@Override
	protected ContentType getDelegate() {
		return _mailContentType;
	}

}
