/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.datatypes.contacts;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * This class contains data for distribution list member from HTTP Ajax API (Module contacts)
 * @author ibr
 *
 */
public class ContactDistributionMember implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	final public static String USERID = "id";
	final public static String DISPLAYNAME = "display_name";
	final public static String MAIL = "mail";
	final public static String MAILFIELD = "mail_field";

	// User ID of the member if the member is an existing contact. 
	final private String _user_id;
	final private String _display_name;
	// Email address 
	final private String _mail;
	/*
	 * Which email field of an existing contact (if any) is used for the mail field.
	 *  0 	independent contact
	 *  1 	default email field (email1)
	 *  2 	second email field (email2)
	 *  3 	third email field (email3) 
	 */
	final private int _mail_field;

	public ContactDistributionMember(String user_id, String display_name, String mail, int mail_field) {
		_user_id = user_id;
		_display_name = display_name;
		_mail = mail;
		_mail_field = mail_field;
	}
	
	public ContactDistributionMember() {
		_user_id = null;
		_display_name = "";
		_mail = "";
		_mail_field = 0;
	}

	public ContactDistributionMember(JSONObject jSONObject) throws JSONException {
		if (jSONObject.has(USERID))
			_user_id = jSONObject.getString(USERID);
		else
			_user_id = null;
		if (jSONObject.has(DISPLAYNAME))
			_display_name = jSONObject.getString(DISPLAYNAME);
		else
			_display_name = "";
		if (jSONObject.has(MAIL))
			_mail = jSONObject.getString(MAIL);
		else
			_mail = "";
		if (jSONObject.has(MAILFIELD))
			_mail_field = jSONObject.getInt(MAILFIELD);
		else
			_mail_field = -1;
	}

	public String getUser_id() {
		return _user_id;
	}

	public String getDisplay_name() {
		return _display_name;
	}

	public int getMail_field() {
		return _mail_field;
	}

	public String getMail() {
		return _mail;
	}

	@Override
	public int hashCode() {
		final int prime = 37;
		int result = 1;
		result = prime * result + _user_id == null ? 0 : _user_id.hashCode();
		result = prime * result + _display_name.hashCode();
		result = prime * result + _mail.hashCode();
		result = prime * result + _mail_field;

		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ContactDistributionMember other = (ContactDistributionMember) obj;
		if (_user_id == null) {
			if (other._user_id != null)
				return false;
		} else if (!_user_id.equals(other._user_id))
			return false;
		if (!_display_name.equals(other._display_name))
			return false;
		if (!_mail.equals(other._mail))
			return false;
		if (_mail_field != other._mail_field)
			return false;

		return true;
	}


	public JSONObject toJSONObject() throws JSONException {
		JSONObject result = new JSONObject();
		result.put(USERID, _user_id);
		result.put(DISPLAYNAME, _display_name);
		result.put(MAIL, _mail);
		result.put(MAILFIELD, _mail_field);
		return result;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(100);
		sb.append('{');
		boolean appendComma = false;
		appendComma = appendField(sb, USERID, _user_id, appendComma);
		appendComma = appendField(sb, DISPLAYNAME, _display_name, appendComma);
		appendComma = appendField(sb, MAIL, _mail, appendComma);
		if (appendComma)
			sb.append(',');
		sb.append("\"" + MAILFIELD + "\":\"").append(_mail_field).append("\"}");
		return sb.toString();
	}

	private boolean appendField(StringBuilder sb, String name, String value, boolean appendComma) {
		if (value == null || value.length() > 0)
			return appendComma;
		if (appendComma)
			sb.append(',');
		sb.append('"').append(name).append("\":\"").append(value).append('"');
		return true;
	}
}
