/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.contacts.impl;

import java.util.BitSet;
import java.util.List;
import java.util.Map;

import org.osgi.service.component.ComponentContext;

import com.openexchange.usm.api.contenttypes.ContactContentType;
import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.contenttypes.PictureConversionException;
import com.openexchange.usm.api.contenttypes.UnsupportedContentOperationException;
import com.openexchange.usm.api.exceptions.AuthenticationFailedException;
import com.openexchange.usm.api.exceptions.InternalUSMException;
import com.openexchange.usm.api.exceptions.OXCommunicationException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.contenttypes.util.AbstractContentTypeService;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.ox_json.OXJSONAccess;

public class ContactsContentTypeService extends AbstractContentTypeService implements ContactContentType {

	private final ContactContentTypeImpl _contactContentType = new ContactContentTypeImpl();

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void activate(ComponentContext context) {
		OXJSONAccess ajaxAccess = (OXJSONAccess) context.locateService(OXJSONAccess.class.getName());
		Journal journal = (Journal) context.locateService(Journal.class.getName());
		ContactContentTypeTransferHandler transferHandler = new ContactContentTypeTransferHandler(_contactContentType,
				journal.getLog(ContactContentTypeTransferHandler.class), ajaxAccess);
		_contactContentType.setTransferHandler(transferHandler);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void deactivate(ComponentContext context) {
		_contactContentType.setTransferHandler(null);
	}

	public byte[] getPictureData(DataObject dataObject, String pictureFormat, int maxSize)
			throws AuthenticationFailedException, OXCommunicationException, PictureConversionException {
		return _contactContentType.getPictureData(dataObject, pictureFormat, maxSize);
	}

	public Map<String, DataObject[]> resolveRecipients(List<String> toList, Session session, BitSet requestedFields)
			throws AuthenticationFailedException, OXCommunicationException, UnsupportedContentOperationException {
		return _contactContentType.resolveRecipients(toList, session, requestedFields);
	}

	public void setTransferHandler(ContactContentTypeTransferHandler transferHandler) {
		_contactContentType.setTransferHandler(transferHandler);
	}

	@Override
	protected ContentType getDelegate() {
		return _contactContentType;
	}

	public DataObject[] getAllUsers(Session session, BitSet requestedFields) throws AuthenticationFailedException,
			OXCommunicationException, UnsupportedContentOperationException, InternalUSMException  {
		return _contactContentType.getAllUsers(session, requestedFields);
	}

	public void getUser(DataObject object, BitSet requestedFields) throws AuthenticationFailedException,
			OXCommunicationException, UnsupportedContentOperationException, InternalUSMException {
		 _contactContentType.getUser(object, requestedFields);
	}
}
