/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.calendar.impl;

import java.util.BitSet;

import org.osgi.service.component.ComponentContext;

import com.openexchange.usm.api.contenttypes.AppointmentContentType;
import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.exceptions.AuthenticationFailedException;
import com.openexchange.usm.api.exceptions.OXCommunicationException;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.contenttypes.util.AbstractContentTypeService;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.ox_json.OXJSONAccess;

public class AppointmentContentTypeService extends AbstractContentTypeService implements AppointmentContentType {

	private final AppointmentContentTypeImpl _appointmentContentType = new AppointmentContentTypeImpl();

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void activate(ComponentContext context) {
		OXJSONAccess ajaxAccess = (OXJSONAccess) context.locateService(OXJSONAccess.class.getName());
		Journal journal = (Journal) context.locateService(Journal.class.getName());
		AppointmentContentTypeTransferHandler transferHandler = new AppointmentContentTypeTransferHandler(
				_appointmentContentType, journal.getLog(AppointmentContentTypeTransferHandler.class), ajaxAccess);
		_appointmentContentType.setTransferHandler(transferHandler);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void deactivate(ComponentContext context) {
		_appointmentContentType.setTransferHandler(null);
	}

	public void confirm(DataObject object, int response) throws AuthenticationFailedException, OXCommunicationException {
		_appointmentContentType.confirm(object, response);
	}

	public DataObject[] getAllAppointments(Session session, BitSet requestedFields) throws USMException {
		return _appointmentContentType.getAllAppointments(session, requestedFields);
	}

	public DataObject[] getAllRecurrencesAsAppointments(Session session, BitSet requestedFields, DataObject seriesObject)
			throws USMException {
		return _appointmentContentType.getAllRecurrencesAsAppointments(session, requestedFields, seriesObject);
	}

	@Override
	protected ContentType getDelegate() {
		return _appointmentContentType;
	}

	public String resolveUID(Session session, String uid) throws USMException {
		return _appointmentContentType.resolveUID(session, uid);
	}

}
