/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.configuration;

/**
 * Global interface where all configuration keys for the various USM parts are stored, along
 * with their description. An interface with String constants is used to allow for extensibility
 * without having to change the API while still providing a common place for all configuration
 * options.
 * 
 * @author afe
 *
 */
public class ConfigurationProperties {

	/**
	 * Read USM access rights from configuration. 
	 */
	public final static String USM_INTERFACE_CONFIG_PROPERTY = "com.openexchange.usm.access_check_module";

	public final static String USM_INTERFACE_CONFIG_DEFAULT = "";

	/**
	 * Used by the OXAjaxAccess bundle to determine base url for all calls to the OX server
	 */
	public final static String OX_ACCESS_URL_PROPERTY = "com.openexchange.usm.ox.url";

	/**
	 * Default value for the base url of the OX server.
	 * TODO Replace the value for development with some useful default for client installations (e.g. localhost)
	 */
	public final static String OX_ACCESS_URL_DEFAULT = "http://localhost/ajax/";

	/**
	 * Used by the OXAjaxAccess bundle to determine pattern for results of post requests to OX server. The
	 * action will be determined using the key "**action**", the result will be determined using the
	 * key "**json**".
	 */
	public final static String OX_ACCESS_POST_RESULT_PATTERN_PROPERTY = "com.openexchange.usm.ox.post_result_pattern";

	/**
	 * Default value for the pattern for results of post requests to the OX server.
	 */
	public final static String OX_ACCESS_POST_RESULT_PATTERN_DEFAULT = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\"http://www.w3.org/TR/html4/strict.dtd\"><html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"> <script type=\"text/javascript\"> function callback(arg) { parent.callback_**action**(arg); }; callback(**json**);</script></head></html>";

	/**
	 * Specifies the overall maximum number of connections the USM may use for requests to the OX server.
	 */
	public static final String OX_ACCESS_MAX_CONNECTIONS_PROPERTY = "com.openexchange.usm.ox.max_connections";

	/**
	 * Default value for the overall maximum number of connections the USM may use for requests to the OX server.
	 */
	public static final int OX_ACCESS_MAX_CONNECTIONS_DEFAULT = 100;

	/**
	 * Specifies the time (in milliseconds) after which idle connections to the OX server will be closed.
	 */
	public static final String OX_ACCESS_CONNECTION_TIMEOUT_PROPERTY = "com.openexchange.usm.ox.idle_connection_timeout";

	/**
	 * Default value for the time (in milliseconds) after which idle connections to the OX server will be closed.
	 */
	public static final int OX_ACCESS_CONNECTION_TIMEOUT_DEFAULT = 60000;

	/**
	 * Specifies if the HttpClient should perform stale checking of Connections before using them (increases security, lowers performance).
	 */
	public static final String OX_ACCESS_PERFORM_STALE_CHECKING_PROPERTY = "com.openexchange.usm.ox.perform_stale_checking";

	/**
	 * Default value for stale checking of Connections before using them (increases security, lowers performance).
	 */
	public static final boolean OX_ACCESS_PERFORM_STALE_CHECKING_DEFAULT = true;

	/**
	 * Used by the slow and incremental syncer to limit the number of retries if a concurrent modification
	 * is detected while performing a synchronization with a client.
	 */
	public final static String SYNC_CONCURRENT_MODIFICATION_MAX_RETRIES_PROPERTY = "com.openexchange.usm.session.sync.concurrent_modification_retries";

	/**
	 * Default value for the max. number of retries of syncs that failed due to concurrent modifications on the server.
	 */
	public final static int SYNC_CONCURRENT_MODIFICATION_MAX_RETRIES_DEFAULT = 3;

	/**
	 * Defines the delay that is used when waiting for changes in email folders (Session.waitForChanges()) after which
	 * a pull on email folders is performed. The delay can either be specified as a fixed value in milliseconds which
	 * defines the maximum time to wait (if the waitForChanges waits for a smaller interval, the pull will be performed
	 * at the end of the wait) or as a percentage (integer ending with a "%"), which indicates a portion of the given
	 * wait interval after which the pull will be performed.<br>
	 * Note that the effective delay will be modified by the com.openexchange.usm.session.sync.email_pull_min_delay
	 * property which may increase the delay or prohibit a pull completely.
	 */
	public final static String SYNC_EMAIL_PULL_DELAY_PROPERTY = "com.openexchange.usm.session.sync.email_pull_delay";

	/**
	 * Default value for the email pull delay, the pull will be performed after half the time given to waitForChanges
	 * has passed.
	 */
	public final static String SYNC_EMAIL_PULL_DELAY_DEFAULT = "50%";

	/**
	 * Defines the minimum delay that is required when waiting for changes in email folders (Session.waitForChanges())
	 * after which a pull on email folders will be performed. The value specified is in milliseconds. The effective
	 * delay will be the maximum of this property and the result of the computation based on the
	 * com.openexchange.usm.session.sync.email_pull_delay property and the value specified as parameter to the
	 * waitForChanges()-call. If the effective value is greater than the parameter to the waitForChanges()-call,
	 * no pull will be performed.<br>
	 * To disable pulling completely, set the value of this property to a negative value.
	 */
	public final static String SYNC_EMAIL_PULL_MIN_DELAY_PROPERTY = "com.openexchange.usm.session.sync.email_pull_min_delay";

	/**
	 * Default value (1 minute) for the minimum wait interval required before an email pull is performed.
	 */
	public final static int SYNC_EMAIL_PULL_MIN_DELAY_DEFAULT = 60000;

	/**
	 * Defines a limit on the number of sync states that are stored in the database and local memory cache
	 * for each folder and the folder hierarchy itself (per session/client). If a client connects to the USM
	 * with a given sync state, all older states are automatically removed, the new state is computed, stored in
	 * the database and sent to the client. As long a client uses an old synckey, new keys keep getting generated,
	 * but none deleted. If the limit specified here is reached, the USM deletes the oldest sync state on a client
	 * connect. Based on the value of the property com.openexchange.usm.session.sync.keep_last_sent_state_in_db
	 * the USM either deletes the oldest sync state (false) or the oldest one that's not equal to the one the client
	 * just used to sync with (true).
	 * Note that the value of this property imposes an upper limit to the number of sync states stored in the cache
	 * and database. If a client behaves as expected, only 2 states will be stored (the one used by the client to
	 * initiate synchronization in case the synchronization result does not reach the client, and the new generated
	 * one that contains the base state for the next synchronization).
	 * The lower limit for this property is 2, since at least 2 sync states are required to account for communication
	 * failures.
	 */
	public static final String SYNC_MAX_STATES_IN_DB_PROPERTY = "com.openexchange.usm.session.sync.max_states_in_db";

	/**
	 * Default value(5) for com.openexchange.usm.session.sync.max_states_in_db.
	 */
	public static final int SYNC_MAX_STATES_IN_DB_DEFAULT = 5;

	/**
	 * If this property is set to true, the USM ensures that the sync state corresponding to the last sync key that was
	 * used by a client stays in the cache and database. If set to false, the USM always deletes the oldest sync state
	 * if the limit of allowed sync states is reached for a folder.
	 */
	public static final String SYNC_KEEP_LAST_SENT_STATE_IN_DB_PROPERTY = "com.openexchange.usm.session.sync.keep_last_sent_state_in_db";

	/**
	 * Default value(true) for com.openexchange.usm.session.sync.keep_last_sent_state_in_db.
	 */
	public static final boolean SYNC_KEEP_LAST_SENT_STATE_IN_DB_DEFAULT = true;

	
	//Database connection properties

	public static final String MYSQL_DATABASE_HOST_PROPERTY = "com.openexchange.usm.database.mysql.host";

	public static final String MYSQL_DATABASE_PORT_PROPERTY = "com.openexchange.usm.database.mysql.port";

	public static final String MYSQL_DATABASE_NAME_PROPERTY = "com.openexchange.usm.database.mysql.dbname";

	public static final String MYSQL_DATABASE_USER_PROPERTY = "com.openexchange.usm.database.mysql.user";

	public static final String MYSQL_DATABASE_PASSWORD_PROPERTY = "com.openexchange.usm.database.mysql.password";

	public static final String MYSQL_DATABASE_HOST_PROPERTY_DEFAULT = "localhost";

	public static final String MYSQL_DATABASE_PORT_PROPERTY_DEFAULT = "3306";

	public static final String MYSQL_DATABASE_NAME_PROPERTY_DEFAULT = "test";

	public static final String MYSQL_DATABASE_USER_PROPERTY_DEFAULT = "";

	public static final String MYSQL_DATABASE_PASSWORD_PROPERTY_DEFAULT = "";

	public static final String HSQL_CONNECTION_PROPERTY = "com.openexchange.usm.database.hsql.url";

	public static final String HSQL_CONNECTION_DEFAULT = "jdbc:hsqldb:file:db/hsqldb";

	public static final String HSQL_USER_PROPERTY = "com.openexchange.usm.database.hsql.user";

	public static final String HSQL_USER_DEFAULT = "sa";

	public static final String HSQL_PASSWORD_PROPERTY = "com.openexchange.usm.database.hsql.password";

	public static final String HSQL_PASSWORD_DEFAULT = "";

	// TODO Create properties for this value ! Why this strange default value ?
	public static final long START_DATE_MINUS_DEFAULT = 311040000l;//36000*24*360

	// TODO Create properties for this value ! Why this strange default value ?
	public static final long END_DATE_PLUS_DEFAULT = 3110400l;//360*24*360


	public static final String JSON_SERVLET_ALIAS_PROPERTY = "com.openexchange.usm.json.alias";

	public static final String JSON_SERVLET_ALIAS_DEFAULT = "/usm-json";
	
	public static final String JSON_SERVLET_PING_MIN_INTERVAL = "com.openexchange.usm.json.ping.min_interval";

	public static final int JSON_SERVLET_PING_MIN_INTERVAL_DEFAULT = 5000;
	
	public static final String JSON_SERVLET_PING_MAX_INTERVAL = "com.openexchange.usm.json.ping.max_interval";

	public static final int JSON_SERVLET_PING_MAX_INTERVAL_DEFAULT = Integer.MAX_VALUE;
	
	public static final String JSON_SERVLET_PING_MAX_REQUEST_PER_SECOND = "com.openexchange.usm.json.ping.max_requests_per_second";

	public static final int JSON_SERVLET_PING_MAX_REQUEST_PER_SECOND_DEFAULT = 100;
	
	
	public static final String SYNCML_SERVLET_ALIAS_PROPERTY = "com.openexchange.usm.syncml.alias";

	public static final String SYNCML_SERVLET_ALIAS_DEFAULT = "/usm-syncml";

	public static final String SYNCML_SYNC_TIMEOUT_PROPERTY = "com.openexchange.usm.syncml.timeout";

	public static final int SYNCML_SYNC_TIMEOUT_DEFAULT = 600000; // 10 minutes

	public static final String SYNCML_FORMATTED_SERVER_ANCHORS_PROPERTY = "com.openexchange.usm.syncml.formatted_server_anchors";

	public static final boolean SYNCML_FORMATTED_SERVER_ANCHORS_DEFAULT = false;

	public static final String SYNCML_DEFAULT_MAX_MESSAGE_SIZE_PROPERTY = "com.openexchange.usm.syncml.default_max_message_size";

	public static final int SYNCML_DEFAULT_MAX_MESSAGE_SIZE_DEFAULT = 10000;

	public static final String SYNCML_SYNC_ALL_FOLDERS_PROPERTY = "com.openexchange.usm.syncml.sync_all_folders";

	public static final boolean SYNCML_SYNC_ALL_FOLDERS_DEFAULT = false;

	public static final String SYNCML_REDIRECT_URLS_PROPERTY = "com.openexchange.usm.syncml.redirect_urls";

	public static final boolean SYNCML_REDIRECT_URLS_DEFAULT = true;
}
