/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.contenttypes;

import java.util.BitSet;

import org.json.JSONObject;

import com.openexchange.usm.api.exceptions.*;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;

/**
 * Handler for the entire interaction with the OX server for the Mail Content Type.
 * 
 * @author ldo
 *
 */
public interface MailContentType extends ContentType {

	public static final String FILTER_MARKED_AS_DELETED_MAILS = "filterMarkedAsDeletedMails";

	int ALL_FLAGS = 1 | 2 | 4 | 8 | 16 | 32 | 64 | 256;

	/**
	 * Sends a mail as MIME data block.
	 * @param mail
	 * @param session
	 * @throws AuthenticationFailedException
	 * @throws OXCommunicationException
	 */
	void sendMail(String mail, Session session) throws USMException;

	/**
	 * Gets a mail data object from the server ready as reply or forward mail. 
	 * @param session
	 * @param messageID
	 * @param folderID
	 * @param action
	 * @return
	 * @throws USMException
	 */
	DataObject getReplyForward(Session session, String messageID, String folderID, String action) throws USMException;

	/**
	 * Gets the mail source as byte array.
	 * @param object
	 * @param requestedFields
	 * @return
	 * @throws USMException
	 */
	byte[] readMailSource(DataObject object, BitSet requestedFields) throws USMException;

	/**
	 * Creates a new mail and saves it in its parent folder. The mail is not send out!
	 * @param folderId
	 * @param flag
	 * @param mailMIMEdataBlock the MIME block as String (the entire email)
	 * @param session
	 * @return the ID of the newly created mail
	 * @throws USMException
	 */
	String createNewMail(String folderId, int flag, String mailMIMEdataBlock, Session session) throws USMException;

	/**
	 * Retrieves the specified mail attachment for a mail as binary data.
	 * 
	 * @param session
	 * @param folderId
	 * @param mailId
	 * @param attachmentId
	 * @return the resource object
	 * @throws USMException
	 */
	Object getMailAttachment(Session session, String folderId, String mailId, String attachmentId) throws USMException;

	/**
	 * Retrieves a mail from the server as structured mail object. 
	 * The result is returned as JSONObject as it can not be stored in the DataObject itself. 
	 *  
	 * @param object the mail data object
	 * @param requestedFields the requested extra fields (body, headers, user)
	 * @return JSONObject
	 * @throws USMException
	 */
	JSONObject readStructuredMail(DataObject object, BitSet requestedFields) throws USMException;
}
